/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.datamodel.impl;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.CommentedObject;
import org.obo.datamodel.DefinedObject;
import org.obo.datamodel.IdentifiedObject;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.AbstractOWLMetadataMapping;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOWLMetadataMapping
extends AbstractOWLMetadataMapping {
    protected static final Logger logger = Logger.getLogger(SimpleOWLMetadataMapping.class);

    @Override
    public boolean isOboToOWLLossy() {
        return true;
    }

    @Override
    public String getName() {
        return "Simple mapping";
    }

    @Override
    public String getDesc() {
        return "Uses basic RDFS vocabulary for all metadata";
    }

    @Override
    public Set<OWLAxiom> getOWLAxioms(OWLAdapter adapter, OWLEntity owlEntity, IdentifiedObject io) {
        String def;
        String comment;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        this.setFactory(adapter.getOwlFactory());
        if (io instanceof CommentedObject && (comment = ((CommentedObject)io).getComment()) != null && !comment.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), comment));
        }
        if (io instanceof DefinedObject && (def = ((DefinedObject)io).getDefinition()) != null && !def.equals("")) {
            axioms.add((OWLAxiom)this.getAnnotationAxiom(owlEntity, OWLRDFVocabulary.RDFS_COMMENT.getURI(), def));
        }
        return axioms;
    }

    @Override
    public boolean translateOWLAxiom(OWLAnnotationAxiom axiom, IdentifiedObject lo, OWLAdapter adapter) {
        OWLAnnotation owlAnnot = axiom.getAnnotation();
        URI uri = owlAnnot.getAnnotationURI();
        if (owlAnnot.isAnnotationByConstant()) {
            String val = owlAnnot.getAnnotationValueAsConstant().getLiteral();
            if (uri.equals(OWLRDFVocabulary.RDFS_COMMENT.getURI())) {
                if (lo instanceof CommentedObject) {
                    ((CommentedObject)lo).setComment(val);
                }
                return true;
            }
        }
        return false;
    }
}

