/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.owl.datamodel.impl.NCBOOboInOWLMetadataMapping;
import org.obo.owl.test.AbstractOWLTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOWLTest
extends AbstractOWLTest {
    protected static final Logger logger = Logger.getLogger(BasicOWLTest.class);

    public BasicOWLTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"nucleus.obo", "bfo.obo", "camphor_catabolism.obo", "part_of_test.obo", "regulation_of_transcription_xp.obo"};
        return Arrays.asList(files);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        BasicOWLTest.addTests(suite);
        return suite;
    }

    public void testLinks() throws Exception {
        this.testForIsA("CHEBI:33304", "CHEBI:33675");
        this.testForLink("testA", "part_of", "testB");
        this.testForIsTransitive("part_of");
    }

    @Override
    public void testHasLoaded() throws IOException, DataAdapterException {
        File outFile = this.writeTempOWLFile(new NCBOOboInOWLMetadataMapping());
        this.readOWLFile(outFile);
        this.writeTempOBOFile();
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new BasicOWLTest("testHasLoaded"));
        suite.addTest((Test)new BasicOWLTest("testLinks"));
    }
}

