/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.datamodel.impl.NCBOOboInOWLMetadataMapping;
import org.obo.owl.test.AbstractOWLTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NCBOStyleOWLTest
extends AbstractOWLTest {
    protected static final Logger logger = Logger.getLogger(NCBOStyleOWLTest.class);

    public NCBOStyleOWLTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"cell.owl"};
        return Arrays.asList(files);
    }

    @Override
    protected OBOSession getSessionFromResources(Collection<String> names) throws DataAdapterException {
        OWLAdapter adapter = new OWLAdapter();
        OWLAdapter.OWLAdapterConfiguration config = new OWLAdapter.OWLAdapterConfiguration();
        config.addMetadataMapping(new NCBOOboInOWLMetadataMapping());
        for (String f : names) {
            String path = f.startsWith("/") ? f : this.getResourcePath() + "/" + f;
            config.getReadPaths().add(path);
        }
        config.setAllowLossy(true);
        this.session = adapter.doOperation(OWLAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        return this.session;
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        NCBOStyleOWLTest.addTests(suite);
        return suite;
    }

    @Override
    public void testHasLoaded() throws IOException, DataAdapterException {
        File f = this.writeTempOBOFile();
        this.readOBOFile(f);
        this.writeTempOWLFile();
    }

    public void testContents() {
        this.testForName("CL:0000134", "mesenchymal cell");
        for (IdentifiedObject io : this.session.getObjects()) {
            if (!io.getID().equals("CL:0000134")) continue;
            NCBOStyleOWLTest.assertTrue((boolean)io.getName().equals("mesenchymal cell"));
        }
        IdentifiedObject io = this.session.getObject("CL:0000335");
        for (Link link : ((LinkedObject)io).getParents()) {
            LinkedObject p = link.getParent();
            OBOProperty t = link.getType();
            NCBOStyleOWLTest.assertTrue((boolean)p.getName().equals("mesenchymal cell"));
            NCBOStyleOWLTest.assertTrue((boolean)t.isTransitive());
            NCBOStyleOWLTest.assertTrue((boolean)t.getName().equals("develops_from"));
        }
        io = this.session.getObject("CL:0000000");
        boolean ok = false;
        for (Link link : ((LinkedObject)io).getChildren()) {
            LinkedObject c = link.getChild();
            OBOProperty t = link.getType();
            logger.info((Object)link);
            if (!c.getName().equals("cell in vivo")) continue;
            ok = true;
        }
        NCBOStyleOWLTest.assertTrue((boolean)ok);
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new NCBOStyleOWLTest("testContents"));
        suite.addTest((Test)new NCBOStyleOWLTest("testHasLoaded"));
    }
}

