/*
 * Decompiled with CFR 0.152.
 */
package org.obo.owl.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.OBOSession;
import org.obo.owl.dataadapter.OWLAdapter;
import org.obo.owl.test.AbstractOWLTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualTest
extends AbstractOWLTest {
    protected static final Logger logger = Logger.getLogger(OWLIndividualTest.class);

    public OWLIndividualTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"individuals.owl"};
        return Arrays.asList(files);
    }

    @Override
    protected OBOSession getSessionFromResources(Collection<String> names) throws DataAdapterException {
        OWLAdapter adapter = new OWLAdapter();
        OWLAdapter.OWLAdapterConfiguration config = new OWLAdapter.OWLAdapterConfiguration();
        for (String f : names) {
            String path = f.startsWith("/") ? f : this.getResourcePath() + "/" + f;
            config.getReadPaths().add("file:" + path);
        }
        config.setAllowLossy(true);
        this.session = adapter.doOperation(OWLAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        return this.session;
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        OWLIndividualTest.addTests(suite);
        return suite;
    }

    @Override
    public void readOBOFile(File file) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(file.getAbsolutePath());
        config.setAllowDangling(true);
        config.setBasicSave(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    @Override
    public void testHasLoaded() throws IOException, DataAdapterException {
        File f = this.writeTempOBOFile();
        this.readOBOFile(f);
        this.writeTempOWLFile();
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new OWLIndividualTest("testHasLoaded"));
    }
}

