/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOObject;
import org.obo.query.Query;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceObjQuery
implements Query<OBOObject, OBOObject> {
    protected Collection<String> namespaceIDs = new HashSet<String>();
    protected boolean allowObsoletes = true;
    protected boolean allowNonObsoletes = true;
    private boolean justTerms = true;
    protected Comparator<OBOObject> comparator = new Comparator<OBOObject>(){

        @Override
        public int compare(OBOObject o1, OBOObject o2) {
            if (o1.getName() == null && o2.getName() == null) {
                return 0;
            }
            if (o1.getName() == null) {
                return 1;
            }
            if (o2.getName() == null) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public NamespaceObjQuery() {
    }

    public NamespaceObjQuery(boolean justTerms, Namespace ... namespaces) {
        this.justTerms = justTerms;
        for (Namespace ns : namespaces) {
            this.namespaceIDs.add(ns.getID());
        }
    }

    public void setAllowObsoletes(boolean allowObsoletes) {
        this.allowObsoletes = allowObsoletes;
    }

    public boolean getAllowObsoletes() {
        return this.allowObsoletes;
    }

    public boolean getAllowNonObsoletes() {
        return this.allowNonObsoletes;
    }

    public void setJustTerms(boolean justTerms) {
        this.justTerms = justTerms;
    }

    public boolean getJustTerms() {
        return this.justTerms;
    }

    public NamespaceObjQuery(String ... namespaceIDs) {
        for (String ns : namespaceIDs) {
            this.namespaceIDs.add(ns);
        }
    }

    public NamespaceObjQuery(Collection<String> namespaceIDs, boolean allowObsoletes, boolean allowNonObsoletes) {
        this.namespaceIDs = namespaceIDs;
        this.setAllowNonObsoletes(allowNonObsoletes);
        this.setAllowObsoletes(allowObsoletes);
    }

    public void setAllowNonObsoletes(boolean allowNonObsoletes) {
        this.allowNonObsoletes = allowNonObsoletes;
    }

    public NamespaceObjQuery(Collection<String> namespaceIDs) {
        this(namespaceIDs, true, true);
    }

    @Override
    public OBOObject convertToInputType(OBOObject original) {
        return original;
    }

    @Override
    public Collection<OBOObject> createResultHolder() {
        return new ArrayList<OBOObject>();
    }

    public void setComparator(Comparator<OBOObject> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<OBOObject> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<OBOObject> getInputType() {
        return OBOObject.class;
    }

    @Override
    public OBOObject matches(OBOObject a) {
        if (a.isBuiltIn()) {
            return null;
        }
        if (!this.typeCheck(a)) {
            return null;
        }
        if (!this.namespaceMatch(a)) {
            return null;
        }
        if (!this.obsoleteCheck(a)) {
            return null;
        }
        return a;
    }

    private boolean namespaceMatch(OBOObject obj) {
        if (this.namespaceIDs.isEmpty()) {
            return true;
        }
        if (obj.getNamespace() == null) {
            return false;
        }
        return this.namespaceIDs.contains(obj.getNamespace().getID());
    }

    private boolean obsoleteCheck(OBOObject obj) {
        boolean isObsolete = TermUtil.isObsolete(obj);
        if (!isObsolete && this.allowNonObsoletes) {
            return true;
        }
        return isObsolete && this.allowObsoletes;
    }

    private boolean typeCheck(OBOObject obj) {
        if (TermUtil.isClass(obj) && this.justTerms) {
            return true;
        }
        return TermUtil.isProperty(obj) && !this.justTerms;
    }

    public boolean equals(Object o) {
        if (o instanceof NamespaceObjQuery) {
            NamespaceObjQuery nq = (NamespaceObjQuery)o;
            return ObjectUtil.equals(nq.getNamespaceIDs(), this.namespaceIDs) && this.getAllowObsoletes() == nq.getAllowObsoletes() && this.getAllowNonObsoletes() == nq.getAllowNonObsoletes();
        }
        return false;
    }

    public Collection<String> getNamespaceIDs() {
        return this.namespaceIDs;
    }

    @Override
    public OBOObject convertToOutputType(OBOObject original) {
        return original;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return null;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }
}

