/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.bbop.util.ObjectUtil;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOClass;
import org.obo.query.Query;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceQuery
implements Query<OBOClass, OBOClass> {
    protected static final Logger logger = Logger.getLogger(NamespaceQuery.class);
    protected Collection<String> namespaceIDs = new HashSet<String>();
    protected boolean allowObsoletes = true;
    protected boolean allowNonObsoletes = true;
    protected Comparator<OBOClass> comparator = new Comparator<OBOClass>(){

        @Override
        public int compare(OBOClass o1, OBOClass o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public NamespaceQuery() {
    }

    public NamespaceQuery(Namespace ... namespaces) {
        for (Namespace ns : namespaces) {
            this.namespaceIDs.add(ns.getID());
        }
    }

    public void setAllowObsoletes(boolean allowObsoletes) {
        this.allowObsoletes = allowObsoletes;
    }

    public boolean getAllowObsoletes() {
        return this.allowObsoletes;
    }

    public boolean getAllowNonObsoletes() {
        return this.allowNonObsoletes;
    }

    public NamespaceQuery(String ... namespaceIDs) {
        for (String ns : namespaceIDs) {
            this.namespaceIDs.add(ns);
        }
    }

    public NamespaceQuery(Collection<String> namespaceIDs, boolean allowObsoletes, boolean allowNonObsoletes) {
        this.namespaceIDs = namespaceIDs;
        this.setAllowNonObsoletes(allowNonObsoletes);
        this.setAllowObsoletes(allowObsoletes);
    }

    public void setAllowNonObsoletes(boolean allowNonObsoletes) {
        this.allowNonObsoletes = allowNonObsoletes;
    }

    public NamespaceQuery(Collection<String> namespaceIDs) {
        this(namespaceIDs, true, true);
    }

    @Override
    public OBOClass convertToInputType(OBOClass original) {
        return original;
    }

    @Override
    public Collection<OBOClass> createResultHolder() {
        return new ArrayList<OBOClass>();
    }

    public void setComparator(Comparator<OBOClass> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<OBOClass> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<OBOClass> getInputType() {
        return OBOClass.class;
    }

    @Override
    public OBOClass matches(OBOClass a) {
        boolean isObsolete = TermUtil.isObsolete(a);
        if (!a.isBuiltIn() && TermUtil.isClass(a) && (this.namespaceIDs.size() == 0 || this.namespaceIDs.contains(a.getNamespace().getID())) && (!isObsolete && this.allowNonObsoletes || isObsolete && this.allowObsoletes)) {
            return a;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof NamespaceQuery) {
            NamespaceQuery nq = (NamespaceQuery)o;
            return ObjectUtil.equals(nq.getNamespaceIDs(), this.namespaceIDs) && this.getAllowObsoletes() == nq.getAllowObsoletes() && this.getAllowNonObsoletes() == nq.getAllowNonObsoletes();
        }
        return false;
    }

    public Collection<String> getNamespaceIDs() {
        return this.namespaceIDs;
    }

    @Override
    public OBOClass convertToOutputType(OBOClass original) {
        return original;
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return null;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }
}

