/*
 * Decompiled with CFR 0.152.
 */
package org.obo.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.obo.datamodel.FieldPath;
import org.obo.datamodel.FieldPathSpec;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.Synonym;
import org.obo.query.StringQuery;
import org.obo.query.impl.SearchHit;
import org.obo.query.impl.TextSearchHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextQuery
implements StringQuery<OBOClass, TextSearchHit> {
    protected static final Logger logger = Logger.getLogger(TextQuery.class);
    protected Comparator<TextSearchHit> comparator = new Comparator<TextSearchHit>(){

        @Override
        public int compare(TextSearchHit o1, TextSearchHit o2) {
            if (o1 instanceof TextSearchHit && o2 instanceof TextSearchHit) {
                int rank2;
                TextSearchHit s1 = o1;
                TextSearchHit s2 = o2;
                int rank1 = TextQuery.this.getRank(s1.getHitType());
                if (rank1 - (rank2 = TextQuery.this.getRank(s2.getHitType())) != 0) {
                    return rank1 - rank2;
                }
                if (s1.getHitPosition() != s2.getHitPosition() && (s1.getHitPosition() == 0 || s2.getHitPosition() == 0)) {
                    if (s1.getHitPosition() == 0) {
                        return -1;
                    }
                    return 1;
                }
            }
            if (TextQuery.this.ignoreCase) {
                return o1.getHit().getName().compareToIgnoreCase(o2.getHit().getName());
            }
            return o1.getHit().getName().compareTo(o2.getHit().getName());
        }
    };
    protected String searchString;
    protected String lowercaseString;
    protected Collection<HitType> hitTypes = new LinkedList<HitType>();
    protected boolean ignoreCase = true;

    protected int getRank(HitType type) {
        if (type == HitType.NAME) {
            return 1;
        }
        if (type == HitType.ID) {
            return 2;
        }
        if (type == HitType.SYNONYM) {
            return 3;
        }
        if (type == HitType.DEFINITION) {
            return 4;
        }
        if (type == HitType.COMMENT) {
            return 5;
        }
        throw new IllegalArgumentException("Unexpected hittype");
    }

    public void setSearchTypes(Collection<HitType> types) {
        this.hitTypes = types;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setSearchTypes(HitType ... types) {
        this.hitTypes.clear();
        for (HitType t : types) {
            this.hitTypes.add(t);
        }
    }

    @Override
    public void setSearchString(String searchString) {
        this.searchString = searchString;
        this.lowercaseString = searchString.toLowerCase();
    }

    @Override
    public OBOClass convertToInputType(TextSearchHit original) {
        return original.result;
    }

    @Override
    public Collection<TextSearchHit> createResultHolder() {
        return new ArrayList<TextSearchHit>();
    }

    @Override
    public Comparator<TextSearchHit> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<IdentifiedObject> getInputType() {
        return IdentifiedObject.class;
    }

    protected String getString(String s) {
        if (this.ignoreCase) {
            return s.toLowerCase();
        }
        return s;
    }

    public String getSearchString() {
        if (this.ignoreCase) {
            return this.lowercaseString;
        }
        return this.searchString;
    }

    @Override
    public TextSearchHit matches(OBOClass a) {
        int pos;
        if (this.hitTypes.contains((Object)HitType.NAME) && (pos = this.getString(a.getName()).indexOf(this.getSearchString())) >= 0) {
            return new TextSearchHit(a, a.getName(), HitType.NAME, pos);
        }
        if (this.hitTypes.contains((Object)HitType.DEFINITION) && (pos = this.getString(a.getDefinition()).indexOf(this.getSearchString())) >= 0) {
            return new TextSearchHit(a, a.getDefinition(), HitType.DEFINITION, pos);
        }
        if (this.hitTypes.contains((Object)HitType.COMMENT) && (pos = this.getString(a.getComment()).indexOf(this.getSearchString())) >= 0) {
            return new TextSearchHit(a, a.getComment(), HitType.COMMENT, pos);
        }
        if (this.hitTypes.contains((Object)HitType.ID) && (pos = this.getString(a.getID()).indexOf(this.getSearchString())) >= 0) {
            return new TextSearchHit(a, a.getID(), HitType.ID, pos);
        }
        if (this.hitTypes.contains((Object)HitType.SYNONYM)) {
            for (Synonym s : a.getSynonyms()) {
                int pos2 = this.getString(s.getText()).indexOf(this.getSearchString());
                if (pos2 < 0) continue;
                return new TextSearchHit(a, s.getText(), HitType.SYNONYM, pos2);
            }
        }
        return null;
    }

    @Override
    public IdentifiedObject convertToInputType(SearchHit<IdentifiedObject> original) {
        return original.getHit();
    }

    @Override
    public TextSearchHit convertToOutputType(OBOClass a) {
        return new TextSearchHit(a, a.getName(), HitType.NAME, 0);
    }

    @Override
    public Collection<FieldPathSpec> getInputPaths() {
        return null;
    }

    @Override
    public void setFieldPath(FieldPath path) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HitType {
        NAME,
        SYNONYM,
        DEFINITION,
        ID,
        COMMENT;

    }
}

