/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.obo.datamodel.Link;
import org.obo.datamodel.PathCapable;
import org.obo.reasoner.Explanation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExplanation
implements Explanation {
    protected Collection<Link> supportingLinks;
    protected Link explainedLink;

    @Override
    public PathCapable getExplainedObject() {
        return this.getExplainedLink();
    }

    public Link getExplainedLink() {
        return this.explainedLink;
    }

    public void setExplainedLink(Link explainedLink) {
        this.explainedLink = explainedLink;
    }

    @Override
    public Collection<Link> getEvidence() {
        if (this.supportingLinks == null) {
            return Collections.emptySet();
        }
        return this.supportingLinks;
    }

    @Override
    public String getDesc() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractExplanation) {
            AbstractExplanation exp = (AbstractExplanation)o;
            return exp.getExplanationType().equals((Object)this.getExplanationType()) && ((Object)exp.getEvidence()).equals(this.getEvidence());
        }
        return false;
    }

    @Override
    public void addEvidence(Link link) {
        if (this.supportingLinks == null) {
            this.supportingLinks = new ArrayList<Link>(1);
        }
        if (!this.supportingLinks.contains(link)) {
            this.supportingLinks.add(link);
        }
    }

    @Override
    public boolean removeEvidence(Link link) {
        boolean collapsed = false;
        if (this.supportingLinks != null) {
            collapsed = this.supportingLinks.remove(link);
        }
        if (this.supportingLinks.isEmpty()) {
            this.supportingLinks = null;
            collapsed = true;
        }
        return collapsed;
    }

    public String toString() {
        return (Object)((Object)this.getExplanationType()) + " explained:" + this.explainedLink + " supported_by_n: " + this.getEvidence().size();
    }

    public int hashCode() {
        return this.getExplanationType().hashCode() + ((Object)this.getEvidence()).hashCode();
    }

    @Override
    public void setDesc(String desc) {
    }
}

