/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.util.MultiHashMap;
import org.bbop.util.MultiMap;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.HoldsOverChainExplanation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoldsOverChainRule
extends AbstractReasonerRule {
    protected MultiMap<OBOProperty, OBOProperty> chainMap;
    protected static final Logger logger = Logger.getLogger(HoldsOverChainRule.class);

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        super.init(reasoner);
        this.buildHoldsOverChainMap(reasoner);
    }

    protected void buildHoldsOverChainMap(ReasonedLinkDatabase reasoner) {
        this.chainMap = new MultiHashMap();
        for (IdentifiedObject io : reasoner.getObjects()) {
            OBOProperty prop;
            Collection<List<OBOProperty>> chains;
            if (!(io instanceof OBOProperty) || (chains = (prop = (OBOProperty)io).getHoldsOverChains()) == null) continue;
            for (List<OBOProperty> chain : chains) {
                if (chain.size() != 2) {
                    logger.info((Object)("will not do anything with chains of length !=2 : " + chain));
                    continue;
                }
                for (OBOProperty p2 : chain) {
                    this.chainMap.add((Object)p2, (Object)prop);
                }
            }
        }
    }

    public HoldsOverChainRule() {
        this.setAllowIntersections(true);
    }

    @Override
    protected Collection<Explanation> doGetImplications(ReasonedLinkDatabase reasoner, Link newLink) {
        OBOProperty thisRel = newLink.getType();
        Collection props = (Collection)this.chainMap.get((Object)thisRel);
        if (props == null) {
            return null;
        }
        ArrayList<Explanation> c = new ArrayList<Explanation>();
        for (OBOProperty p : props) {
            boolean found = false;
            for (List<OBOProperty> chain : p.getHoldsOverChains()) {
                HoldsOverChainExplanation exp;
                Link out;
                int pos = chain.indexOf(thisRel);
                if (pos == -1) continue;
                if (pos == 0) {
                    OBOProperty nextRel = chain.get(1);
                    for (LinkedObject parent : reasoner.getParentsOfType(newLink.getParent(), nextRel)) {
                        out = this.createLink(newLink.getChild(), p, parent);
                        exp = new HoldsOverChainExplanation(newLink);
                        exp.setExplainedLink(out);
                        c.add(exp);
                        logger.debug((Object)("HOC: " + out + " // FROM[0]: " + newLink));
                    }
                    found = true;
                    continue;
                }
                if (pos == 1) {
                    OBOProperty prevRel = chain.get(0);
                    for (Link link : reasoner.getChildren(newLink.getChild())) {
                        if (!link.getType().equals(prevRel)) continue;
                        out = this.createLink(link.getChild(), p, newLink.getParent());
                        exp = new HoldsOverChainExplanation(newLink);
                        exp.setExplainedLink(out);
                        c.add(exp);
                        logger.debug((Object)("HOC: " + out + " // FROM[1]: " + newLink));
                    }
                    found = true;
                    continue;
                }
                logger.error((Object)("assertion error: position of " + thisRel + " in " + p + " is: " + pos));
            }
            if (found) continue;
            logger.error((Object)("assertion error: could not find " + thisRel));
        }
        return c;
    }
}

