/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.NestedValue;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.PathCapable;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.impl.AbstractExplanation;
import org.obo.reasoner.impl.AbstractReasoner;
import org.obo.reasoner.impl.AbstractReasonerRule;
import org.obo.reasoner.impl.GenusDifferentiaRule;
import org.obo.reasoner.impl.GivenExplanation;
import org.obo.reasoner.impl.HoldsOverChainRule;
import org.obo.reasoner.impl.IntersectionRule;
import org.obo.reasoner.impl.PropertyIntersectionRule;
import org.obo.reasoner.impl.ReasonerRule;
import org.obo.reasoner.impl.SimpleTransitivityRule;
import org.obo.reasoner.impl.TransitiveOverRule;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkPileReasoner
extends AbstractReasoner {
    protected static final Logger logger = Logger.getLogger(LinkPileReasoner.class);
    protected Collection<Link> linkPile;
    protected List<ReasonerRule> rules = new ArrayList<ReasonerRule>();
    protected int maxLinkPileSize = 0;
    protected int lastVal;
    protected HashMap<Link, Link> linkMap;
    protected boolean lowMemoryMode = false;

    public LinkPileReasoner() {
        this.setStoreGivenLinks(false);
        this.addDefaultRules();
    }

    protected void addDefaultRules() {
        this.addRule(new SimpleTransitivityRule());
        this.addRule(new GenusDifferentiaRule());
        this.addRule(new IntersectionRule());
        this.addRule(new TransitiveOverRule());
        this.addRule(new HoldsOverChainRule());
        this.addRule(new PropertyIntersectionRule());
    }

    @Override
    public Number getProgressValue() {
        int val;
        if (this.maxLinkPileSize == 0) {
            val = 0;
        } else {
            val = 100 * (this.maxLinkPileSize - this.linkPile.size()) / this.maxLinkPileSize;
            if (val < this.lastVal) {
                val = this.lastVal;
            } else if (val > 99) {
                val = 99;
            } else if (val < 0) {
                val = 0;
            }
        }
        this.lastVal = val;
        return val;
    }

    @Override
    protected void doReasoning() {
        for (ReasonerRule rule : this.rules) {
            rule.init(this);
        }
        this.setProgressString("Initializing reasoner...");
        this.linkPile = new LinkedHashSet<Link>();
        Iterator<Link> it = TermUtil.getAllLinks(this.linkDatabase);
        while (it.hasNext()) {
            Link link = it.next();
            this.linkPile.add(link);
            if (!this.storeGivenLinks) continue;
            GivenExplanation e = new GivenExplanation(link);
            this.addExplanation(e);
        }
        this.setProgressString("Reasoning...");
        this.maxLinkPileSize = this.linkPile.size();
        this.siftPile();
        for (ReasonerRule rule : this.rules) {
            rule.end(this);
        }
    }

    public void addRule(ReasonerRule rule) {
        this.rules.add(rule);
        rule.install(this);
    }

    public void removeRule(ReasonerRule rule) {
        this.rules.remove(rule);
        rule.uninstall(this);
    }

    @Override
    protected void doAddLink(Link link) {
        logger.debug((Object)"LinkPileReasoner.doAddLink");
        this.linkPile.add(link);
        if (this.storeGivenLinks) {
            this.addExplanation(new GivenExplanation(link));
        }
        this.siftPile();
    }

    protected Collection<Link> getLinkPile() {
        return this.linkPile;
    }

    protected Link popLink() {
        if (this.linkPile instanceof Queue) {
            return (Link)((Queue)this.linkPile).poll();
        }
        Iterator<Link> it = this.linkPile.iterator();
        Link out = it.next();
        it.remove();
        return out;
    }

    protected void siftPile() {
        long addTimeFalse = 0L;
        long addTimeTrue = 0L;
        long initTime = System.nanoTime();
        int addCount = 0;
        int addTrueCount = 0;
        int readdedCount = 0;
        int newaddedCount = 0;
        long pilePullTime = 0L;
        while (!this.linkPile.isEmpty()) {
            if (this.isCancelled()) {
                return;
            }
            long time = System.nanoTime();
            Link link = this.popLink();
            pilePullTime += System.nanoTime() - time;
            if (this.isLookedAt(link)) continue;
            this.setLookedAt(link);
            for (ReasonerRule rule : this.rules) {
                Collection<Explanation> exps = rule.getImplications(this, link);
                if (exps == null) continue;
                for (Explanation e : exps) {
                    Link newLink;
                    time = System.nanoTime();
                    boolean added = this.addExplanation(e);
                    addTimeTrue += System.nanoTime() - time;
                    if (!added || !(e.getExplainedObject() instanceof Link) || this.isLookedAt(newLink = (Link)e.getExplainedObject())) continue;
                    this.linkPile.add(newLink);
                    if (this.linkPile.size() < this.maxLinkPileSize) continue;
                    this.maxLinkPileSize = this.linkPile.size();
                }
            }
        }
        long totalTime = System.nanoTime() - initTime;
        logger.info((Object)("   Total reasoner time = " + (double)totalTime / 1000000.0 + " ms"));
        logger.info((Object)("   Add time(true(" + addTrueCount + ")) = " + (double)addTimeTrue / 1000000.0 + " ms"));
        logger.info((Object)("   Add time(false(" + (addCount - addTrueCount) + ")) = " + (double)addTimeFalse / 1000000.0 + " ms"));
        logger.info((Object)("   Pile pull time: " + (double)pilePullTime / 1000000.0 + " ms"));
        logger.info((Object)(" readdedCount = " + readdedCount));
        logger.info((Object)(" newaddedCount = " + newaddedCount));
        for (ReasonerRule rule : this.rules) {
            if (!(rule instanceof AbstractReasonerRule)) continue;
            logger.info((Object)("   time in rule (" + rule + ") = " + (double)((AbstractReasonerRule)rule).ruleTime / 1000000.0 + " ms"));
        }
    }

    protected boolean addExplanation(Explanation explanation) {
        Link link = (Link)explanation.getExplainedObject();
        this.explain(link, explanation);
        return true;
    }

    protected boolean isLookedAt(Link link) {
        if (link instanceof ReasonerLink) {
            return ((ReasonerLink)link).isLookedAt();
        }
        return false;
    }

    protected void setLookedAt(Link link) {
        if (link instanceof ReasonerLink) {
            ((ReasonerLink)link).setLookedAt(true);
        }
    }

    @Override
    protected void reasonRemoval(Link link) {
        this.reasonRemoval(link, new HashSet<Link>());
    }

    protected void reasonRemoval(PathCapable pc, Collection<Link> seenem) {
        if (pc instanceof Link) {
            this.reasonRemoval((Link)pc, seenem);
        }
    }

    protected void reasonRemoval(Link link, Collection<Link> seenem) {
        logger.info((Object)("Removing link: " + link));
        if (seenem.contains(link)) {
            return;
        }
        seenem.add(link);
        this.impliedLinkDatabase.removeParent(link);
        this.linkMap.remove(link);
        ArrayList<Explanation> deps = new ArrayList<Explanation>();
        for (ReasonerRule rule : this.rules) {
            Collection<Explanation> temp = rule.getImplications(this, link);
            if (temp != null) {
                deps.addAll(temp);
            }
            if (!(rule instanceof IntersectionRule)) continue;
            for (Link childLink : this.getChildren(link.getChild())) {
                ReasonerLink newLink = new ReasonerLink(childLink.getChild(), childLink.getType(), link.getParent());
                temp = rule.getImplications(this, newLink);
                if (temp == null) continue;
                deps.addAll(temp);
            }
        }
        for (Explanation exp : deps) {
            Collection<Explanation> exps = this.getExplanations(exp.getExplainedObject());
            exps.remove(exp);
            boolean dead = exp.removeEvidence(link);
            if (!exps.isEmpty()) continue;
            this.reasonRemoval(exp.getExplainedObject(), seenem);
        }
    }

    @Override
    public Collection<Explanation> getExplanations(PathCapable pc) {
        HashSet<Explanation> expls = new HashSet<Explanation>();
        if (pc instanceof Link) {
            Link rl;
            Link link = (Link)pc;
            if (!(link instanceof ReasonerLink)) {
                expls.add(new GivenExplanation(link));
            }
            if ((rl = this.findRealLink(link)) instanceof ReasonerLink) {
                return ((ReasonerLink)rl).getExplanations();
            }
        }
        return expls;
    }

    public Collection<Explanation> johns_version_of_getExplanations_which_I_dont_understand(PathCapable link) {
        if (link instanceof ReasonerLink) {
            ReasonerLink rl = (ReasonerLink)link;
            if (!rl.isLookedAt()) {
                rl = (ReasonerLink)this.findRealLink(rl);
            }
            return rl.getExplanations();
        }
        if (link instanceof Link && !TermUtil.isImplied(link)) {
            return Collections.singleton(new GivenExplanation((Link)link));
        }
        return Collections.emptySet();
    }

    public Link findRealLink(Link link) {
        Link candidate;
        if (this.lowMemoryMode) {
            return TermUtil.getLink(this.impliedLinkDatabase, link);
        }
        if (this.linkMap == null) {
            this.linkMap = new HashMap();
        }
        if ((candidate = this.linkMap.get(link)) == null) {
            this.linkMap.put(link, link);
        } else {
            link = candidate;
        }
        return link;
    }

    @Override
    protected void internalAddExplanation(Link link, Explanation explanation) {
        if (link instanceof ReasonerLink && explanation instanceof AbstractExplanation) {
            link = this.findRealLink(link);
            ((ReasonerLink)link).addExplanation((AbstractExplanation)explanation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReasonerLink
    implements Link {
        protected LinkedObject child;
        protected LinkedObject parent;
        protected OBOProperty type;
        protected boolean lookedAt;
        protected HashSet<AbstractExplanation> explanations;
        protected String id;
        protected int hash;

        public ReasonerLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
            this.child = child;
            this.type = type;
            this.parent = parent;
            this.id = child.getID() + '-' + type.getID() + "->" + parent.getID();
            this.hash = child.hashCode() + type.hashCode() + parent.hashCode();
        }

        public Collection<AbstractExplanation> getExplanations() {
            if (this.explanations == null) {
                return Collections.emptyList();
            }
            return this.explanations;
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public void addExplanation(AbstractExplanation exp) {
            exp.setExplainedLink(this);
            if (this.explanations == null) {
                this.explanations = new HashSet(5);
            }
            this.explanations.add(exp);
        }

        public void removeExplanation(AbstractExplanation exp) {
            if (this.explanations != null) {
                this.explanations.remove(exp);
            }
        }

        @Override
        public boolean isImplied() {
            return true;
        }

        @Override
        public String getID() {
            return this.id;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.child + " -> " + this.type + " -> " + this.parent;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Link) {
                return TermUtil.equals(this, (Link)o);
            }
            return false;
        }

        @Override
        public void setNestedValue(NestedValue nv) {
        }

        @Override
        public NestedValue getNestedValue() {
            return null;
        }

        @Override
        public boolean isAnonymous() {
            return false;
        }

        @Override
        public void setNamespace(Namespace namespace) {
        }

        @Override
        public Namespace getNamespace() {
            return null;
        }

        @Override
        public LinkedObject getChild() {
            return this.child;
        }

        @Override
        public void setChild(LinkedObject child) {
            throw new UnsupportedOperationException();
        }

        @Override
        public LinkedObject getParent() {
            return this.parent;
        }

        @Override
        public void setParent(LinkedObject parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OBOProperty getType() {
            return this.type;
        }

        @Override
        public void setType(OBOProperty type) {
            throw new UnsupportedOperationException();
        }

        public boolean isLookedAt() {
            return this.lookedAt;
        }

        public void setLookedAt(boolean lookedAt) {
            this.lookedAt = lookedAt;
        }
    }
}

