/*
 * Decompiled with CFR 0.152.
 */
package org.obo.reasoner.rbr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.reasoner.Explanation;
import org.obo.reasoner.ExplanationType;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.rbr.LinkCompositionExplanation;
import org.obo.reasoner.rbr.Rule;
import org.obo.reasoner.rbr.RuleBasedReasoner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRule
implements Rule {
    public long ruleTime;
    protected static final Logger logger = Logger.getLogger(AbstractRule.class);

    @Override
    public void end(ReasonedLinkDatabase reasoner) {
    }

    @Override
    public void init(ReasonedLinkDatabase reasoner) {
        this.ruleTime = 0L;
    }

    @Override
    public void install(ReasonedLinkDatabase reasoner) {
    }

    @Override
    public void uninstall(ReasonedLinkDatabase reasoner) {
    }

    protected Link createLink(LinkedObject child, OBOProperty type, LinkedObject parent) {
        return new RuleBasedReasoner.ReasonerLink(child, type, parent);
    }

    @Override
    public boolean isRedundant(ReasonedLinkDatabase reasoner, Link link) {
        Collection<Explanation> existingExpls = reasoner.getExplanations(link);
        if (existingExpls.size() == 0) {
            return false;
        }
        return existingExpls.size() != 1 || !existingExpls.iterator().next().getExplanationType().equals((Object)ExplanationType.GIVEN);
    }

    protected boolean onlyGiven(Collection<Explanation> expls) {
        return expls.size() == 1 && expls.iterator().next().getExplanationType().equals((Object)ExplanationType.GIVEN);
    }

    public Collection<Explanation> getNewInferencesForComposition(ReasonedLinkDatabase reasoner, OBOProperty inferredProp, OBOProperty p0, OBOProperty p1) {
        long time = System.nanoTime();
        ArrayList<Explanation> expls = new ArrayList<Explanation>();
        for (IdentifiedObject a : reasoner.getObjects()) {
            if (!(a instanceof LinkedObject)) continue;
            LinkedObject ao = (LinkedObject)a;
            HashSet<LinkedObject> seenObjs = new HashSet<LinkedObject>();
            HashSet<LinkedObject> extObjs = new HashSet<LinkedObject>();
            extObjs.addAll(reasoner.getParentsOfType(ao, p0));
            while (extObjs.size() > 0) {
                HashSet<LinkedObject> newExtObjs = new HashSet<LinkedObject>();
                for (LinkedObject bo : extObjs) {
                    for (LinkedObject co : reasoner.getParentsOfType(bo, p1)) {
                        Collection<Explanation> existingExpls;
                        Link existingLink;
                        if (seenObjs.contains(co) || (existingLink = reasoner.hasRelationship(ao, inferredProp, co)) != null && !this.onlyGiven(existingExpls = reasoner.getExplanations(existingLink))) continue;
                        Link out = this.createLink(ao, inferredProp, co);
                        LinkCompositionExplanation exp = new LinkCompositionExplanation(this.createLink(ao, p0, bo), this.createLink(bo, p1, co));
                        exp.setExplainedLink(out);
                        expls.add(exp);
                        if (inferredProp.equals(p0)) {
                            newExtObjs.add(co);
                        }
                        seenObjs.add(co);
                    }
                }
                extObjs = newExtObjs;
            }
        }
        this.ruleTime += System.nanoTime() - time;
        return expls;
    }
}

