/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.GOStyleAnnotationFileAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.LinkedObject;
import org.obo.test.AbstractOBOTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationTest
extends AbstractOBOTest {
    protected AbstractAnnotationTest(String name) {
        super(name);
    }

    public void testForAnnotation(String su, String ob) {
        AbstractAnnotationTest.assertTrue((this.getFirstAnnotation(su, ob) != null ? 1 : 0) != 0);
    }

    public void testForAnnotationAssignedBy(String su, String ob, String by) {
        AbstractAnnotationTest.assertTrue((boolean)this.getFirstAnnotation(su, ob).getAssignedBy().getID().equals(by));
    }

    public void testForAnnotationPublication(String su, String ob, String pubId) {
        AbstractAnnotationTest.assertTrue((this.getFirstAnnotationWithPublication(su, ob, pubId) != null ? 1 : 0) != 0);
    }

    public void testForAnnotationWithEvidenceCode(String su, String ob, String code) {
        AbstractAnnotationTest.assertTrue((this.getFirstAnnotationWithEvidenceCode(su, ob, code) != null ? 1 : 0) != 0);
    }

    public Annotation getFirstAnnotationWithPublication(String su, String ob, String pubId) {
        for (Annotation annot : this.getAllAnnotations(su, ob)) {
            for (LinkedObject pub : annot.getSources()) {
                if (!pub.getID().equals(pubId)) continue;
                return annot;
            }
        }
        return null;
    }

    public Annotation getFirstAnnotationWithEvidenceCode(String su, String ob, String code) {
        for (Annotation annot : this.getAllAnnotations(su, ob)) {
            for (LinkedObject ev : annot.getEvidence()) {
                if (!((Instance)ev).getType().getID().equals(code)) continue;
                return annot;
            }
        }
        return null;
    }

    public Annotation getFirstAnnotation(String su, String ob) {
        IdentifiedObject io = this.session.getObject(su);
        if (io != null) {
            Collection<Annotation> annots = this.getAnnotationsForSubject(io);
            for (Annotation annot : annots) {
                if (!ob.equals(annot.getObject().getID())) continue;
                return annot;
            }
        }
        return null;
    }

    public Collection<Annotation> getAllAnnotations(String su, String ob) {
        IdentifiedObject io = this.session.getObject(su);
        HashSet<Annotation> matches = new HashSet<Annotation>();
        if (io != null) {
            Collection<Annotation> annots = this.getAnnotationsForSubject(io);
            for (Annotation annot : annots) {
                if (!ob.equals(annot.getObject().getID())) continue;
                matches.add(annot);
            }
        }
        return matches;
    }

    public Collection<Annotation> getAnnotationsForSubject(String id) {
        return this.getAnnotationsForSubject(this.session.getObject(id));
    }

    public Collection<Annotation> getAnnotationsForSubject(IdentifiedObject su) {
        LinkedList<Annotation> annots = new LinkedList<Annotation>();
        for (IdentifiedObject io : this.session.getObjects()) {
            Annotation annot;
            if (!(io instanceof Annotation) || !su.equals((annot = (Annotation)io).getSubject())) continue;
            annots.add(annot);
        }
        return annots;
    }

    public File writeTempAssocFile() throws IOException, DataAdapterException {
        GOStyleAnnotationFileAdapter adapter = new GOStyleAnnotationFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        File outFile = File.createTempFile("foo", "bar");
        config.setWritePath(outFile.getAbsolutePath());
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        return outFile;
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"gene_assoc.test"};
        return Arrays.asList(files);
    }
}

