/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.OBDSQLDatabaseAdapter;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.impl.OBOClassImpl;
import org.obo.datamodel.impl.OBOSessionImpl;
import org.obo.test.AbstractAnnotationTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBDQueryTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(OBDQueryTest.class);
    String jdbcPath = "jdbc:postgresql://localhost:5432/obd_phenotype_full";

    protected OBDQueryTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{""};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
    }

    public void testQuery() throws SQLException, ClassNotFoundException, IOException, DataAdapterException {
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration wconfig = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        wconfig.setReadPath(this.jdbcPath);
        OBDSQLDatabaseAdapter wadapter = new OBDSQLDatabaseAdapter();
        wadapter.setConfiguration(wconfig);
        wadapter.connect();
        this.session = new OBOSessionImpl();
        this.session.setDefaultNamespace(new Namespace("test"));
        Collection<Annotation> annots = wadapter.fetchAnnotationsByObject(this.session, new OBOClassImpl("GO:0006811"));
        logger.info((Object)("N matching annots:" + annots.size()));
        for (Annotation annot : annots) {
            logger.info((Object)("  match:" + annot));
        }
        OBDQueryTest.assertTrue((annots.size() > 0 ? 1 : 0) != 0);
        int numAnnots = wadapter.fetchAnnotationCountByObject(this.session, new OBOClassImpl("GO:0006811"));
        logger.info((Object)("N matching annots (count q):" + numAnnots));
        OBDQueryTest.assertTrue((numAnnots > 0 ? 1 : 0) != 0);
        OBDQueryTest.assertTrue((numAnnots == annots.size() ? 1 : 0) != 0);
        float ic = wadapter.fetchAnnotationInformationContentByObject(this.session, new OBOClassImpl("GO:0006811"));
        logger.info((Object)("IC:" + ic));
        OBDQueryTest.assertTrue((ic > 0.0f ? 1 : 0) != 0);
        this.writeTempOBOFile();
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        OBDQueryTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new OBDQueryTest("testQuery"));
    }
}

