/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.dataadapter.OBDSQLDatabaseAdapter;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.dataadapter.OBOSerializationEngine;
import org.obo.datamodel.impl.DefaultLinkDatabase;
import org.obo.reasoner.ReasonedLinkDatabase;
import org.obo.reasoner.impl.ForwardChainingReasoner;
import org.obo.reasoner.impl.ForwardChainingReasonerFactory;
import org.obo.test.AbstractOBOTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBDSaveTest
extends AbstractOBOTest {
    protected static final Logger logger = Logger.getLogger(OBDSaveTest.class);
    protected String jdbcPath = "jdbc:postgresql://localhost:5432/obdtest";

    protected OBDSaveTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"nucleus.obo", "caro.obo", "camphor_catabolism.obo", "craniata.obo"};
        return Arrays.asList(files);
    }

    @Override
    public void setUp() throws Exception {
        logger.info((Object)("Setting up: " + (Object)((Object)this)));
        ForwardChainingReasoner.checkRecache = false;
        this.session = this.getSessionFromResources(this.getFilesToLoad());
        this.linkDatabase = new DefaultLinkDatabase(this.session);
        ForwardChainingReasonerFactory rf = new ForwardChainingReasonerFactory();
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration config = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        config.setSaveImplied(true);
        config.setWritePath(this.jdbcPath);
        OBDSQLDatabaseAdapter adapter = new OBDSQLDatabaseAdapter();
        ReasonedLinkDatabase reasoner = rf.createReasoner();
        reasoner.setLinkDatabase(this.linkDatabase);
        adapter.setReasoner(reasoner);
        reasoner.recache();
        adapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)config, this.session);
        logger.info((Object)"saved");
        logger.info((Object)"reading");
        config.setReadPath(this.jdbcPath);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        logger.info((Object)("read: " + this.session));
    }

    public void testHasLoaded() {
        this.testForIsA("GO:0005634", "GO:0043231");
        this.testForLink("GO:0044464", "part_of", "GO:0005623");
        this.testForNamespace("GO:0044464", "cellular_component");
        this.testForDefinition("GO:0005623", "The basic structural and functional unit of all organisms. Includes the plasma membrane and any external encapsulating structures such as the cell wall and cell envelope.");
        this.testForCategory("GO:0043227", "gosubset_prok");
        this.testForDbxref("CARO:0000013", "GO:0005623");
        this.testForName("GO:0005634", "nucleus");
        this.testForSynonym("GO:0005622", "protoplasm");
        this.testForSynonym("CHEBI:26872", "fake_for_test");
    }

    public void testNamespaceFilteredLoad() throws DataAdapterException {
        OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration config = new OBDSQLDatabaseAdapter.OBDSQLDatabaseAdapterConfiguration();
        OBDSQLDatabaseAdapter adapter = new OBDSQLDatabaseAdapter();
        logger.info((Object)"reading ns filtered");
        config.addNamespace("caro");
        config.setReadPath(this.jdbcPath);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
        logger.info((Object)("read: " + this.session));
        this.testForIsA("CARO:0000003", "CARO:0000006");
        this.testNotPresent("GO:0005622");
    }

    public void testFileSave() throws DataAdapterException {
        OBOFileAdapter fileAdapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration fileConfig = new OBOFileAdapter.OBOAdapterConfiguration();
        OBOSerializationEngine.FilteredPath path = new OBOSerializationEngine.FilteredPath();
        path.setUseSessionReasoner(false);
        path.setPath("foo.obo");
        fileConfig.getSaveRecords().add(path);
        fileConfig.setBasicSave(false);
        fileConfig.setSerializer("OBO_1_2");
        fileAdapter.doOperation(OBOAdapter.WRITE_ONTOLOGY, (AdapterConfiguration)fileConfig, this.session);
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        OBDSaveTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new OBDSaveTest("testHasLoaded"));
        suite.addTest((Test)new OBDSaveTest("testFileSave"));
        suite.addTest((Test)new OBDSaveTest("testNamespaceFilteredLoad"));
    }
}

