/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.bbop.io.AuditedPrintStream;
import org.obo.annotation.datamodel.Annotation;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.LinkedObject;
import org.obo.test.AbstractAnnotationTest;
import org.obo.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostcompSyntaxFileTest
extends AbstractAnnotationTest {
    protected static final Logger logger = Logger.getLogger(PostcompSyntaxFileTest.class);

    public PostcompSyntaxFileTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        for (String f : this.getFilesToLoad()) {
            config.getReadPaths().add(this.getResourcePath() + "/" + f);
            logger.info((Object)f);
        }
        config.setAllowDangling(true);
        config.setBasicSave(false);
        this.session = adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    public void testAnnot() throws IOException, DataAdapterException {
        this.testForName("ZFIN:ZDB-GENO-070219-2", "Df(LG03:sox8,sox9b)b971/b971;sox9a<sup>hi1134Tg/hi1134Tg</sup>");
        this.testInstanceType("ZFIN:ZDB-GENO-070219-2", "SO:0001027");
        Collection<Annotation> annots = AnnotationUtil.getAnnotations(this.session);
        for (Annotation annot : annots) {
            logger.info((Object)annot);
            LinkedObject ao = annot.getObject();
            logger.info((Object)("obj name=" + ao.getName()));
        }
        this.writeTempOBOFile();
    }

    public static Test suite() {
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        PostcompSyntaxFileTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new PostcompSyntaxFileTest("testAnnot"));
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"sox9b_zfin.obo"};
        return Arrays.asList(files);
    }
}

