/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.test.AbstractReasonerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonerRedundancyTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(ReasonerRedundancyTest.class);

    public ReasonerRedundancyTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"simple_redundancy_test.obo"};
        return Arrays.asList(files);
    }

    public void testLinks() throws Exception {
        this.testForIsA("A", "B");
        this.testForIsA("D", "B");
        this.testForIsA("D", "A");
        this.testForIsA("E", "B");
        this.testForIsAInTrimmed("E", "D");
        this.testForIsAInTrimmed("D", "A");
        this.testForIsAInTrimmed("A", "B");
        this.testForRedundantIsA("E", "B");
        this.testForNonRedundantIsA("D", "B");
        ReasonerRedundancyTest.assertFalse((boolean)this.hasIsALink(this.trimmedDB, "E", "A"));
    }

    public void testBasicLinks() throws Exception {
        this.testForIsA("X1", "X2");
        this.testForIsA("X2", "X3");
        this.testForIsA("X1", "X3");
        this.testForRedundantIsA("X1", "X3");
    }

    public void testBoneLinks() throws Exception {
        this.testForIsA("endochondral_bone", "bone");
        this.testForIsA("tripus", "bone");
        this.testForIsA("tripus", "endochondral_bone");
        this.testForIsAInTrimmed("tripus", "endochondral_bone");
    }
}

