/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.obo.datamodel.OBOProperty;
import org.obo.test.AbstractReasonerTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubRelationReasonerTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(SubRelationReasonerTest.class);

    public SubRelationReasonerTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"directly_develops_from_test.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    public void testAssertedSubRelation() throws Exception {
        this.testForIsA("directly_develops_from", "develops_from");
        this.testForIsAInTrimmed("directly_develops_from", "develops_from");
    }

    public void testAssertedLink() throws Exception {
        this.testForLink("a", "directly_develops_from", "b");
        this.testForLink("b", "directly_develops_from", "c");
    }

    public void testInferredLinkBasic() throws Exception {
        this.testForLink("a", "develops_from", "b");
    }

    public void testInferredLink() throws Exception {
        this.testForLink("a", "develops_from", "c");
    }

    public void testNegativeInferredLink() throws Exception {
        this.testForNoLink("a", "directly_develops_from", "c");
    }

    public void testNegativeInferredXP() throws Exception {
        this.testForNoIsA("a", "DIRECTLY_Develops_from_C");
    }

    public void testInferredBasic() throws Exception {
        this.testForIsA("DIRECTLY_Develops_from_C", "Develops_from_C");
        this.testForIsAInTrimmed("DIRECTLY_Develops_from_C", "Develops_from_C");
    }

    public void testInferredXP() throws Exception {
        this.testForIsA("b", "DIRECTLY_Develops_from_C");
        this.testForIsAInTrimmed("b", "DIRECTLY_Develops_from_C");
        this.testForIsA("b", "Develops_from_C");
        this.testForNoIsAInTrimmed("b", "Develops_from_C");
        this.testForIsA("a", "Develops_from_C");
        this.testForIsAInTrimmed("a", "Develops_from_C");
    }

    public void testTrim() throws Exception {
    }

    public void testMetadata() throws Exception {
        OBOProperty p = (OBOProperty)this.session.getObject("metadata_test_relation");
        SubRelationReasonerTest.assertTrue((boolean)p.isMetadataTag());
        SubRelationReasonerTest.assertTrue((boolean)p.isNonInheritable());
    }
}

