/*
 * Decompiled with CFR 0.152.
 */
package org.obo.test;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.bbop.io.AuditedPrintStream;
import org.obo.datamodel.Link;
import org.obo.test.AbstractReasonerTest;
import org.obo.util.ReasonerUtil;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimmingLibraryTest
extends AbstractReasonerTest {
    protected static final Logger logger = Logger.getLogger(TrimmingLibraryTest.class);
    protected long oldTime = 0L;
    protected long newTime = 0L;

    protected TrimmingLibraryTest(String name) {
        super(name);
    }

    @Override
    public Collection<String> getFilesToLoad() {
        String[] files = new String[]{"so-xp.obo"};
        return Arrays.asList(files);
    }

    public static Collection<String> getTests() {
        String[] tests = new String[]{};
        return Arrays.asList(tests);
    }

    protected boolean testLink(Link link) throws Exception {
        boolean match;
        long time = System.nanoTime();
        boolean firstResult = ReasonerUtil.shouldBeTrimmed(this.reasonedDB, link);
        this.oldTime += System.nanoTime() - time;
        time = System.nanoTime();
        boolean secondResult = ReasonerUtil.shouldBeTrimmedNew(this.reasonedDB, link);
        this.newTime += System.nanoTime() - time;
        boolean bl = match = firstResult == secondResult;
        if (!match) {
            logger.info((Object)("testing link: " + link));
            logger.info((Object)("    original implementation (" + firstResult + ") = " + this.oldTime));
            logger.info((Object)("    new implementation (" + secondResult + ") = " + this.newTime));
        }
        return match;
    }

    public void testLinks() throws Exception {
        this.oldTime = 0L;
        this.newTime = 0L;
        Iterator<Link> it = TermUtil.getAllLinks(this.reasonedDB);
        while (it.hasNext()) {
            Link link = it.next();
            if (TermUtil.isIntersection(link)) continue;
            boolean match = this.testLink(link);
            TrimmingLibraryTest.assertTrue((boolean)match);
        }
        logger.info((Object)("original implementation time = " + this.oldTime));
        logger.info((Object)("new implementation time = " + this.newTime));
    }

    public static Test suite() {
        logger.info((Object)"foo");
        AuditedPrintStream audited = new AuditedPrintStream(System.err, 25, true);
        System.setErr((PrintStream)audited);
        TestSuite suite = new TestSuite();
        TrimmingLibraryTest.addTests(suite);
        return suite;
    }

    public static void addTests(TestSuite suite) {
        suite.addTest((Test)new TrimmingLibraryTest("testLinks"));
    }
}

