/*
 * Decompiled with CFR 0.152.
 */
package org.obo.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOProperty;
import org.obo.datamodel.OBOSession;
import org.obo.filters.EqualsComparison;
import org.obo.filters.ObjectFilter;
import org.obo.filters.ObjectFilterFactory;
import org.obo.util.TermUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSearchUtil {
    protected static final Logger logger = Logger.getLogger(WebSearchUtil.class);

    public static String createQueryString(SearchableDatabase style, Collection<String> terms) {
        StringBuffer sb = new StringBuffer();
        if (style.equals((Object)SearchableDatabase.NCBI)) {
            sb.append("(");
        }
        int i = 0;
        for (String term : terms) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append("\"" + term + "\"");
            if (style.equals((Object)SearchableDatabase.NCBI)) {
                sb.append("[All Fields]");
            } else if (style.equals((Object)SearchableDatabase.CLINICAL_TRIALS_GOV)) {
                sb.append("[ALL-FIELDS]");
            }
            ++i;
        }
        if (style.equals((Object)SearchableDatabase.NCBI)) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static Set<String> expandSearchTerm(OBOSession session, String label) {
        ObjectFilterFactory off = new ObjectFilterFactory();
        ObjectFilter filter = (ObjectFilter)off.createNewFilter();
        EqualsComparison comparison = new EqualsComparison();
        filter.setComparison(comparison);
        filter.setValue(label);
        LinkedList<IdentifiedObject> objs = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject io : session.getObjects()) {
            if (!filter.satisfies(io)) continue;
            objs.add(io);
        }
        return WebSearchUtil.expandSearchTerm(objs);
    }

    public static Set<String> expandSearchTerm(Collection<IdentifiedObject> objs) {
        HashSet<String> terms = new HashSet<String>();
        WebSearchUtil.expandSearchTerm(objs, terms, 0);
        return WebSearchUtil.mostGeneral(terms);
    }

    public static Set<String> expandSearchTerm(IdentifiedObject obj) {
        return WebSearchUtil.expandSearchTerm(Collections.singleton(obj));
    }

    private static void expandSearchTerm(Collection<IdentifiedObject> objs, Set<String> terms, int depth) {
        if (objs.size() == 0) {
            return;
        }
        LinkedList<IdentifiedObject> nextObjs = new LinkedList<IdentifiedObject>();
        for (IdentifiedObject io : objs) {
            if (!(io instanceof LinkedObject)) continue;
            Collection<String> labels = TermUtil.getLabels(io);
            terms.addAll(labels);
            for (Link link : ((LinkedObject)io).getChildren()) {
                if (!link.getType().equals(OBOProperty.IS_A)) continue;
                nextObjs.add(link.getChild());
            }
        }
        WebSearchUtil.expandSearchTerm(nextObjs, terms, depth + 1);
    }

    private static Set<String> mostGeneral(Set<String> terms) {
        HashSet<String> gterms = new HashSet<String>();
        for (String s1 : terms) {
            boolean isGeneral = true;
            for (String s2 : terms) {
                if (s1.equals(s2) || !s1.contains(s2)) continue;
                isGeneral = false;
                break;
            }
            if (!isGeneral) continue;
            gterms.add(s1);
        }
        return gterms;
    }

    public static String createSearchURL(SearchResultFormat fmt, SearchableDatabase style, String searchTerm) {
        String url = null;
        if (style.equals((Object)SearchableDatabase.CLINICAL_TRIALS_GOV)) {
            url = "http://clinicaltrials.gov/ct2/results?term=" + searchTerm;
        }
        return url;
    }

    public static void main(String[] args) {
        SearchableDatabase qs = SearchableDatabase.NCBI;
        LinkedList<String> terms = new LinkedList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-style")) {
                String style;
                if ((style = args[++i]).contains("trial")) {
                    qs = SearchableDatabase.CLINICAL_TRIALS_GOV;
                    continue;
                }
                if (style.contains("google")) {
                    qs = SearchableDatabase.GOOGLE;
                    continue;
                }
                qs = SearchableDatabase.NCBI;
                continue;
            }
            terms.add(args[i]);
        }
        String searchTerm = WebSearchUtil.createQueryString(qs, terms);
        logger.info((Object)searchTerm);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchResultFormat {
        HTML,
        XML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchableDatabase {
        NCBI,
        GOOGLE,
        CLINICAL_TRIALS_GOV;

    }
}

