/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.impl;

import java.util.HashSet;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.ValidatorException;
import org.biopax.validator.api.beans.Validation;

public abstract class AbstractCardinalityAndRangeRule<E extends BioPAXElement>
extends AbstractRule<E> {
    protected EditorMap editorMap;
    private final String property;
    private final Class<E> domain;
    private int minCardinality = 0;
    private int maxCardinality = Integer.MAX_VALUE;
    Class<?>[] ranges;
    String rangesAsString = "";

    public AbstractCardinalityAndRangeRule(Class<E> domain, String property, int min, int max, Class<?> ... ranges) {
        this.domain = domain;
        this.property = property;
        this.minCardinality = min >= 0 ? min : 0;
        this.maxCardinality = max > 0 ? max : Integer.MAX_VALUE;
        this.ranges = ranges;
        for (Class<?> cl : ranges) {
            this.rangesAsString = this.rangesAsString + cl.getSimpleName() + " ";
        }
    }

    public boolean canCheck(Object thing) {
        return this.domain.isInstance(thing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Validation validation, E thing) {
        PropertyEditor editor = this.editorMap.getEditorForProperty(this.property, thing.getModelInterface());
        if (editor == null) {
            throw new ValidatorException("BUG in " + ((Object)((Object)this)).getClass().getSimpleName() + " rule: no editor exists for property '" + this.property + "' of " + this.domain, new Object[0]);
        }
        HashSet ret = null;
        E e = thing;
        synchronized (e) {
            ret = new HashSet(editor.getValueFromBean(thing));
        }
        int size = ret.size();
        if (this.maxCardinality == this.minCardinality) {
            if (this.maxCardinality > 0 && this.maxCardinality < Integer.MAX_VALUE && size != this.maxCardinality) {
                this.error(validation, thing, "cardinality.violated", false, new Object[]{editor.getProperty(), this.maxCardinality});
            }
        } else {
            if (this.minCardinality > 0 && size == 0) {
                this.error(validation, thing, "min.cardinality.violated", false, new Object[]{editor.getProperty(), this.minCardinality});
            }
            if (this.maxCardinality > 0 && this.maxCardinality < Integer.MAX_VALUE && size > this.maxCardinality) {
                this.error(validation, thing, "max.cardinality.violated", false, new Object[]{editor.getProperty(), this.maxCardinality});
            }
        }
        for (Object val : ret) {
            this.checkRange(validation, thing, val);
        }
    }

    private void checkRange(Validation validation, E thing, Object p) {
        boolean isViolated = true;
        for (Class<?> range : this.ranges) {
            if (!range.isInstance(p)) continue;
            isViolated = false;
            break;
        }
        if (isViolated) {
            this.error(validation, thing, "range.violated", false, new Object[]{this.getProperty(), p, p.getClass().getSimpleName(), this.rangesAsString});
        }
    }

    public EditorMap getEditorMap() {
        return this.editorMap;
    }

    public int getMinCardinality() {
        return this.minCardinality;
    }

    public void setMinCardinality(int minCardinality) {
        this.minCardinality = minCardinality;
    }

    public int getMaxCardinality() {
        return this.maxCardinality;
    }

    public void setMaxCardinality(int maxCardinality) {
        this.maxCardinality = maxCardinality;
    }

    public Class<?>[] getRanges() {
        return this.ranges;
    }

    public void setRanges(Class<?>[] ranges) {
        this.ranges = ranges;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<E> getDomain() {
        return this.domain;
    }
}

