/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.impl;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.CvRestriction;
import org.biopax.validator.api.CvRule;
import org.biopax.validator.api.CvValidator;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCvRule<D extends BioPAXElement>
extends AbstractRule<D>
implements CvRule<D> {
    @Autowired
    protected CvValidator ontologyManager;
    protected final Class<D> domain;
    protected final String property;
    protected final Set<CvRestriction> restrictions;
    private Set<String> validTerms;
    protected PropertyEditor<? super D, ?> editor;

    public AbstractCvRule(Class<D> domain, String property, CvRestriction ... restrictions) {
        this.domain = domain;
        this.property = property;
        this.restrictions = new HashSet<CvRestriction>(restrictions.length);
        for (CvRestriction c : restrictions) {
            this.restrictions.add(c);
        }
    }

    @PostConstruct
    public void init() {
        if (this.ontologyManager == null) {
            throw new IllegalStateException("ontologyManager is NULL!");
        }
        this.setValidTerms(this.ontologyManager.getValidTermNames((CvRule)this));
    }

    public boolean canCheck(Object thing) {
        return this.domain.isInstance(thing);
    }

    public Set<String> getValidTerms() {
        return this.validTerms;
    }

    public void setValidTerms(Set<String> validTerms) {
        this.validTerms = validTerms;
    }

    public Set<CvRestriction> getRestrictions() {
        return this.restrictions;
    }

    public Class<D> getDomain() {
        return this.domain;
    }

    public String getProperty() {
        return this.property;
    }

    public CvValidator getBiopaxOntologyManager() {
        return this.ontologyManager;
    }

    public PropertyEditor<? super D, ?> getEditor() {
        return this.editor;
    }

    protected Set<String> getOntologyIDs() {
        HashSet<String> ids = new HashSet<String>();
        for (CvRestriction restriction : this.restrictions) {
            ids.add(restriction.getOntologyId());
        }
        return ids;
    }
}

