/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.psidev.ontology_manager.OntologyAccess;
import org.biopax.psidev.ontology_manager.OntologyManager;
import org.biopax.psidev.ontology_manager.OntologyTermI;
import org.biopax.validator.api.CvRestriction;
import org.biopax.validator.api.CvRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.impl.AbstractCvRule;
import org.biopax.validator.utils.Normalizer;

public abstract class CvTermsRule<T extends Level3Element>
extends AbstractCvRule<T> {
    public CvTermsRule(Class<T> domain, String property, CvRestriction ... restrictions) {
        super(domain, property, restrictions);
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.editor = this.property != null && !ControlledVocabulary.class.isAssignableFrom(this.domain) ? SimpleEditorMap.L3.getEditorForProperty(this.property, this.domain) : null;
    }

    public void check(Validation validation, T thing) {
        HashSet<ControlledVocabulary> vocabularies = new HashSet<ControlledVocabulary>();
        if (this.editor == null) {
            vocabularies.add((ControlledVocabulary)thing);
        } else {
            vocabularies.addAll(this.editor.getValueFromBean(thing));
        }
        if (vocabularies.isEmpty()) {
            return;
        }
        String cvRuleInfo = (this.editor != null ? " property: " + this.property : "") + " " + this.restrictions.toString();
        for (ControlledVocabulary cv : vocabularies) {
            Set<String> addTerms;
            Object name22;
            if (cv == null) {
                this.logger.warn((Object)(thing + " referes to 'null' controlled vocabulary (bug!): " + ", domain: " + this.domain + ", property: " + this.property));
                continue;
            }
            if (cv.getTerm().isEmpty()) continue;
            HashSet<String> badTerms = new HashSet<String>();
            HashMap<String, Set> noXrefTerms = new HashMap<String, Set>();
            Set terms = Collections.unmodifiableSet(new HashSet(cv.getTerm()));
            for (Object name22 : terms) {
                if (this.getValidTerms().contains(((String)name22).toLowerCase())) continue;
                badTerms.add((String)name22);
            }
            if (!badTerms.isEmpty()) {
                String badTermInfo = ((Object)badTerms).toString();
                this.error(validation, thing, "illegal.cv.term", false, new Object[]{badTermInfo, cvRuleInfo});
            }
            HashSet<UnificationXref> badXrefs = new HashSet<UnificationXref>();
            name22 = new ClassFilterSet(cv.getXref(), UnificationXref.class).iterator();
            while (name22.hasNext()) {
                UnificationXref x = (UnificationXref)name22.next();
                OntologyTermI ot = ((OntologyManager)this.ontologyManager).findTermByAccession(x.getId());
                if (ot != null && this.getValidTerms().contains(ot.getPreferredName().toLowerCase())) continue;
                badXrefs.add(x);
            }
            if (!badXrefs.isEmpty()) {
                String bads = ((Object)badXrefs).toString();
                this.error(validation, thing, "illegal.cv.xref", false, new Object[]{bads, cvRuleInfo});
            }
            for (String name3 : terms) {
                if (!this.getValidTerms().contains(name3.toLowerCase())) continue;
                Set ots = ((OntologyManager)this.ontologyManager).searchTermByName(name3.toLowerCase(), this.getOntologyIDs());
                assert (!ots.isEmpty());
                boolean noXrefsForTermNameFound = true;
                block4: for (OntologyTermI term : ots) {
                    String id = term.getTermAccession();
                    for (UnificationXref x : new ClassFilterSet(cv.getXref(), UnificationXref.class)) {
                        if (!id.equalsIgnoreCase(x.getId())) continue;
                        noXrefsForTermNameFound = false;
                        break block4;
                    }
                }
                if (!noXrefsForTermNameFound) continue;
                noXrefTerms.put(name3, ots);
            }
            if (!noXrefTerms.isEmpty()) {
                String noXrefTermsInfo = ((Object)noXrefTerms).toString();
                boolean fixed = false;
                if (validation.isFix()) {
                    Set validTermIs = this.ontologyManager.getValidTerms((CvRule)this);
                    for (String name4 : noXrefTerms.keySet()) {
                        Set ots = (Set)noXrefTerms.get(name4);
                        HashSet<OntologyTermI> topvalids = new HashSet<OntologyTermI>();
                        for (OntologyTermI term : ots) {
                            OntologyAccess ont;
                            if (!validTermIs.contains(term) || !Collections.disjoint(ots, (ont = ((OntologyManager)this.ontologyManager).getOntology(term.getOntologyId())).getAllParents(term))) continue;
                            topvalids.add(term);
                        }
                        HashSet<String> added = new HashSet<String>();
                        for (OntologyTermI term : topvalids) {
                            String ontId = term.getOntologyId();
                            String db = ((OntologyManager)this.ontologyManager).getOntology(ontId).getName();
                            String id = term.getTermAccession();
                            String uri = Normalizer.uri(cv.getRDFId() + "_", db, id, UnificationXref.class);
                            if (added.contains(uri)) continue;
                            added.add(uri);
                            UnificationXref ux = (UnificationXref)BioPAXLevel.L3.getDefaultFactory().create(UnificationXref.class, uri);
                            ux.setDb(db);
                            ux.setId(id);
                            cv.addXref((Xref)ux);
                            fixed = true;
                            noXrefTermsInfo = noXrefTermsInfo + "; " + id + " added!";
                        }
                    }
                }
                this.error(validation, thing, "no.xref.cv.terms", fixed, new Object[]{noXrefTermsInfo, cvRuleInfo});
            }
            if (validation == null || !validation.isFix() || badTerms.isEmpty() && noXrefTerms.isEmpty() || (addTerms = this.createTermsFromUnificationXrefs(cv)).isEmpty()) continue;
            cv.getTerm().addAll(addTerms);
        }
    }

    private Set<String> createTermsFromUnificationXrefs(ControlledVocabulary cv) {
        HashSet<String> inferred = new HashSet<String>();
        for (UnificationXref x : new ClassFilterSet(cv.getXref(), UnificationXref.class)) {
            OntologyTermI ot = ((OntologyManager)this.ontologyManager).findTermByAccession(x.getId());
            if (ot != null && this.getValidTerms().contains(ot.getPreferredName().toLowerCase())) {
                inferred.add(ot.getPreferredName());
                continue;
            }
            if (ot == null) {
                this.logger.warn((Object)("No term found by the xref.id: " + x.getId()));
                continue;
            }
            this.logger.debug((Object)("Invalid (for this CV context) term: " + x.getId()));
        }
        return inferred;
    }
}

