/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.BiochemicalPathwayStep;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.StepDirection;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class BiochemicalPathwayStepAndCatalysisDirectionRule
extends AbstractRule<BiochemicalPathwayStep> {
    private void fix(BiochemicalPathwayStep t, Object ... values) {
        if (values[0] instanceof Catalysis) {
            ((Catalysis)values[0]).setCatalysisDirection((CatalysisDirectionType)values[1]);
        } else if (values[0] instanceof Conversion) {
            ((Conversion)values[0]).setConversionDirection((ConversionDirectionType)values[1]);
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof BiochemicalPathwayStep;
    }

    public void check(Validation validation, BiochemicalPathwayStep step) {
        if (step.getStepDirection() != null) {
            CatalysisDirectionType correctDir = step.getStepDirection() == StepDirection.LEFT_TO_RIGHT ? CatalysisDirectionType.LEFT_TO_RIGHT : CatalysisDirectionType.RIGHT_TO_LEFT;
            for (Process proc : step.getStepProcess()) {
                CatalysisDirectionType cdir;
                if (!(proc instanceof Catalysis) || (cdir = ((Catalysis)proc).getCatalysisDirection()) == null || cdir == correctDir) continue;
                this.error(validation, step, "direction.conflict", validation.isFix(), new Object[]{"stepDirection=" + step.getStepDirection() + ", but " + proc.getRDFId() + " has catalysisDirection=" + cdir});
                if (!validation.isFix()) continue;
                this.fix(step, proc, null);
            }
            Conversion con = step.getStepConversion();
            if (con != null && con.getConversionDirection() != null && con.getConversionDirection() != ConversionDirectionType.REVERSIBLE) {
                this.error(validation, step, "direction.conflict", validation.isFix(), new Object[]{"stepDirection=" + step.getStepDirection() + ", but  " + con.getRDFId() + " has conversionDirection=" + con.getConversionDirection() + " (must be REVERSIBLE or empty)"});
                if (validation.isFix()) {
                    this.fix(step, con, null);
                }
            }
        } else {
            this.error(validation, step, "direction.conflict", false, new Object[]{"BiochemicalPathwayStep: stepDirection is unknown"});
        }
    }
}

