/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class BiopaxElementIdLengthRule
extends AbstractRule<BioPAXElement> {
    private static final int URI_MAX_LENGTH = 256;

    public boolean canCheck(Object thing) {
        return thing instanceof BioPAXElement;
    }

    public void check(Validation validation, BioPAXElement thing) {
        String rdfid = thing.getRDFId();
        if (rdfid != null && rdfid.length() > 256) {
            this.error(validation, thing, "too.long.id", false, new Object[]{rdfid.length(), 256});
        }
    }
}

