/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashMap;
import java.util.Set;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.Cluster;
import org.springframework.stereotype.Component;

@Component
public class ClonedUtilityClassRule
extends AbstractRule<Model> {
    public void check(Validation validation, Model model) {
        Cluster<UtilityClass> algorithm = new Cluster<UtilityClass>(){

            @Override
            public boolean match(UtilityClass a, UtilityClass b) {
                return !a.equals(b) && a.isEquivalent((BioPAXElement)b);
            }
        };
        Set clusters = algorithm.cluster(model.getObjects(UtilityClass.class), Integer.MAX_VALUE);
        HashMap<UtilityClass, UtilityClass> replacementMap = new HashMap<UtilityClass, UtilityClass>();
        for (Set clones : clusters) {
            if (clones.size() < 2) continue;
            UtilityClass first = (UtilityClass)clones.iterator().next();
            clones.remove(first);
            if (validation.isFix()) {
                this.error(validation, first, "cloned.utility.class", true, new Object[]{clones, first.getModelInterface().getSimpleName()});
                for (UtilityClass clone : clones) {
                    replacementMap.put(clone, first);
                }
                continue;
            }
            this.error(validation, first, "cloned.utility.class", false, new Object[]{clones, first.getModelInterface().getSimpleName()});
        }
        if (validation.isFix()) {
            ModelUtils.replace((Model)model, replacementMap);
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model && ((Model)thing).getLevel() == BioPAXLevel.L3;
    }
}

