/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Arrays;
import java.util.Collection;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PrimitivePropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.util.Filter;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class DataPropertyIllegalValueRule
extends AbstractRule<BioPAXElement> {
    private static final Collection<String> warnOnDataPropertyValues = Arrays.asList("0", "-1", "NULL", "NIL", "NONE", "N/A");

    public boolean canCheck(Object thing) {
        return thing instanceof BioPAXElement;
    }

    public void check(final Validation validation, BioPAXElement bpe) {
        SimpleEditorMap editorMap = bpe instanceof Level3Element ? SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L3) : SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L2);
        Traverser checker = new Traverser((EditorMap)editorMap, new Visitor(){

            public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
                if (range != null && warnOnDataPropertyValues.contains(range.toString().trim().toUpperCase())) {
                    DataPropertyIllegalValueRule.this.error(validation, domain, "illegal.property.value", validation.isFix(), new Object[]{editor.getProperty(), range});
                    if (validation.isFix()) {
                        if (editor.isMultipleCardinality()) {
                            editor.removeValueFromBean(range, domain);
                        }
                        if (!editor.isMultipleCardinality()) {
                            editor.setValueToBean(null, domain);
                        }
                    }
                }
            }
        }, new Filter[]{new Filter<PropertyEditor>(){

            public boolean filter(PropertyEditor ed) {
                return ed instanceof PrimitivePropertyEditor || ed instanceof StringPropertyEditor;
            }
        }});
        checker.traverse(bpe, null);
    }
}

