/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.Normalizer;
import org.springframework.stereotype.Component;

@Component
public class EntityFeatureInverseFunctionalRule
extends AbstractRule<Model> {
    public void check(Validation validation, Model model) {
        HashSet efs = new HashSet(model.getObjects(EntityFeature.class));
        HashSet ers = new HashSet(model.getObjects(EntityReference.class));
        for (EntityFeature ef : efs) {
            EntityReference efOf = ef.getEntityFeatureOf();
            HashSet<EntityReference> ownerEntityRefs = new HashSet<EntityReference>();
            for (EntityReference er : ers) {
                if (!er.getEntityFeature().contains(ef)) continue;
                ownerEntityRefs.add(er);
                if (er.equals(efOf) || !validation.isFix()) continue;
                String newUri = Normalizer.uri(er.getRDFId() + "_", null, ef.getRDFId(), ef.getModelInterface());
                EntityFeature newEf = (EntityFeature)new ShallowCopy().copy((BioPAXElement)ef, newUri);
                model.add((BioPAXElement)newEf);
                er.removeEntityFeature(ef);
                er.addEntityFeature(newEf);
                for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                    if (spe.getFeature().contains(ef)) {
                        spe.removeFeature(ef);
                        spe.addFeature(newEf);
                    }
                    if (!spe.getNotFeature().contains(ef)) continue;
                    spe.removeNotFeature(ef);
                    spe.addNotFeature(newEf);
                }
            }
            if (ownerEntityRefs.size() > 1) {
                this.error(validation, ef, "inverse.functional.violated", validation.isFix(), new Object[]{"entityFeature", ef, ((Object)ownerEntityRefs).toString()});
                continue;
            }
            if (ownerEntityRefs.size() != 1) continue;
            EntityReference er = (EntityReference)ownerEntityRefs.iterator().next();
            if (efOf != null && efOf.equals(er)) continue;
            if (validation.isFix()) {
                er.removeEntityFeature(ef);
                er.addEntityFeature(ef);
            }
            if (efOf == null) continue;
            this.error(validation, efOf, "inverse.functional.violated", validation.isFix(), new Object[]{"entityFeature", ef, er});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Model;
    }
}

