/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.ExperimentalForm;
import org.biopax.paxtools.model.level3.Score;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class EvidencePropertiesUsageRule
extends AbstractRule<Evidence> {
    public void check(Validation validation, Evidence ev) {
        if (!(ev.getEvidenceCode() != null && !ev.getEvidenceCode().isEmpty() || ev.getExperimentalForm() != null && !ev.getExperimentalForm().isEmpty() || ev.getConfidence() != null && !ev.getConfidence().isEmpty())) {
            this.error(validation, ev, "min.cardinality.violated", false, new Object[]{"'evidenceCode' or 'confidence' or 'experimantalForm'", 1});
        } else {
            if (ev.getEvidenceCode() != null) {
                for (Object cv : ev.getEvidenceCode()) {
                    if (EvidenceCodeVocabulary.class.isInstance(cv)) continue;
                    this.error(validation, ev, "range.violated", false, new Object[]{"evidenceCode", cv, cv.getClass().getSimpleName(), "EvidenceCodeVocabulary"});
                }
            }
            if (ev.getExperimentalForm() != null) {
                for (Object cv : ev.getExperimentalForm()) {
                    if (ExperimentalForm.class.isInstance(cv)) continue;
                    this.error(validation, ev, "range.violated", false, new Object[]{"experimentalForm", cv, cv.getClass().getSimpleName(), "ExperimentalForm"});
                }
            }
            if (ev.getConfidence() != null) {
                for (Object cv : ev.getConfidence()) {
                    if (Score.class.isInstance(cv)) continue;
                    this.error(validation, ev, "range.violated", false, new Object[]{"confidence", cv, cv.getClass().getSimpleName(), "Score"});
                }
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof Evidence;
    }
}

