/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.externalReferenceUtilityClass;
import org.biopax.paxtools.model.level2.utilityClass;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.UtilityClass;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class NotAllowedInstancesRule
extends AbstractRule<BioPAXElement> {
    final Class[] NOT_ALLOWED = new Class[]{Entity.class, UtilityClass.class, Xref.class, xref.class, entity.class, utilityClass.class, externalReferenceUtilityClass.class};

    private boolean notAllowed(BioPAXElement bp) {
        for (int i = 0; i < this.NOT_ALLOWED.length; ++i) {
            if (!bp.getModelInterface().equals(this.NOT_ALLOWED[i])) continue;
            return true;
        }
        return false;
    }

    public boolean canCheck(Object thing) {
        if (thing instanceof BioPAXElement) {
            return this.notAllowed((BioPAXElement)thing);
        }
        return false;
    }

    public void check(Validation validation, BioPAXElement thing) {
        this.error(validation, thing, "not.allowed.element", false, new Object[]{thing.getModelInterface().getSimpleName()});
    }
}

