/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.Set;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class PathwayStepProcessesArePathwayComponents
extends AbstractRule<PathwayStep> {
    public boolean canCheck(Object thing) {
        return thing instanceof PathwayStep && ((PathwayStep)thing).getPathwayOrderOf() != null;
    }

    public void check(Validation validation, PathwayStep step) {
        Pathway pathway = step.getPathwayOrderOf();
        if (pathway != null) {
            Set pathwayComponents = pathway.getPathwayComponent();
            for (Process stepProcess : step.getStepProcess()) {
                if (pathwayComponents.contains(stepProcess)) continue;
                this.error(validation, step, "component.not.found", false, new Object[]{stepProcess, pathway});
            }
        }
    }
}

