/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class PhysicalEntityAmbiguousFeatureRule
extends AbstractRule<PhysicalEntity> {
    public void check(Validation validation, PhysicalEntity thing) {
        if (!thing.getParticipantOf().isEmpty() && !thing.getComponentOf().isEmpty()) {
            HashSet efs = new HashSet();
            efs.addAll(thing.getFeature());
            efs.addAll(thing.getNotFeature());
            for (EntityFeature ef : efs) {
                if (!(ef instanceof BindingFeature)) continue;
                return;
            }
            this.error(validation, thing, "ambiguous.feature", false, new Object[]{thing.getName()});
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof PhysicalEntity;
    }
}

