/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Degradation;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.springframework.stereotype.Component;

@Component
public class SimplePhysicalEntityConversionRule
extends AbstractRule<SimplePhysicalEntity> {
    public void check(Validation validation, SimplePhysicalEntity spe) {
        HashSet conversions = new HashSet(new ClassFilterSet(spe.getParticipantOf(), Conversion.class));
        for (Conversion conversion2 : conversions) {
            if (conversion2 instanceof ComplexAssembly || conversion2 instanceof Degradation) continue;
            ClassFilterSet side = new ClassFilterSet(conversion2.getLeft(), SimplePhysicalEntity.class);
            if (side.contains(spe)) {
                side = new ClassFilterSet(conversion2.getRight(), SimplePhysicalEntity.class);
            }
            if (this.sameKindEntityExists(spe, (Set<SimplePhysicalEntity>)side)) continue;
            this.error(validation, spe, "illegal.conversion", false, new Object[]{conversion2});
        }
    }

    boolean sameKindEntityExists(SimplePhysicalEntity spe, Set<SimplePhysicalEntity> side) {
        assert (!(spe instanceof SmallMolecule));
        boolean ret = false;
        for (SimplePhysicalEntity value : side) {
            if (value instanceof SmallMolecule || value.getEntityReference() == null || !value.getEntityReference().isEquivalent((BioPAXElement)spe.getEntityReference())) continue;
            return true;
        }
        return ret;
    }

    public boolean canCheck(Object thing) {
        return thing instanceof SimplePhysicalEntity && !(thing instanceof SmallMolecule);
    }
}

