/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import java.util.HashSet;
import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.Normalizer;
import org.springframework.stereotype.Component;

@Component
public class SimplePhysicalEntityFeaturesRule
extends AbstractRule<SimplePhysicalEntity> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(Validation validation, SimplePhysicalEntity thing) {
        EntityReference er;
        EntityReference entityReference = er = thing.getEntityReference();
        synchronized (entityReference) {
            HashSet erFeatures = new HashSet(er.getEntityFeature());
            HashSet peFeaturesAndNotFeatures = new HashSet();
            peFeaturesAndNotFeatures.addAll(thing.getFeature());
            peFeaturesAndNotFeatures.addAll(thing.getNotFeature());
            for (EntityFeature ef : peFeaturesAndNotFeatures) {
                if (erFeatures.contains(ef)) continue;
                if (validation.isFix()) {
                    if (ef.getEntityFeatureOf() != null) {
                        String uri = Normalizer.uri(er.getRDFId() + "_", null, ef.getRDFId(), ef.getModelInterface());
                        EntityFeature newEf = null;
                        for (EntityFeature f : er.getEntityFeature()) {
                            if (!uri.equals(f.getRDFId())) continue;
                            newEf = f;
                            break;
                        }
                        if (newEf == null) {
                            newEf = (EntityFeature)new ShallowCopy().copy((BioPAXElement)ef, uri);
                            assert (newEf.getEntityFeatureOf() == null) : "getEntityFeatureOf of a shallow copy of EF is not null...";
                        }
                        if (thing.getFeature().contains(ef)) {
                            thing.removeFeature(ef);
                            thing.addFeature(newEf);
                        }
                        if (thing.getNotFeature().contains(ef)) {
                            thing.removeNotFeature(ef);
                            thing.addNotFeature(newEf);
                        }
                        er.addEntityFeature(newEf);
                    } else {
                        er.addEntityFeature(ef);
                    }
                }
                this.error(validation, thing, "improper.feature.use", validation.isFix(), new Object[]{ef.getRDFId(), er.getRDFId()});
            }
        }
    }

    public boolean canCheck(Object thing) {
        return thing instanceof SimplePhysicalEntity && ((SimplePhysicalEntity)thing).getEntityReference() != null;
    }
}

