/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.rules;

import org.biopax.paxtools.model.level3.Xref;
import org.biopax.validator.api.AbstractRule;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.utils.XrefHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XrefSynonymDbRule
extends AbstractRule<Xref> {
    @Autowired
    XrefHelper xrefHelper;

    public boolean canCheck(Object thing) {
        return thing instanceof Xref;
    }

    public void check(Validation validation, Xref x) {
        String db = x.getDb();
        if (db == null) {
            return;
        }
        String primary = this.xrefHelper.getPrimaryDbName(db);
        if (primary != null && !primary.equalsIgnoreCase(db)) {
            if (this.xrefHelper.isUnofficialOrMisspelledDbName(db)) {
                this.error(validation, x, "db.name.spelling", validation.isFix(), new Object[]{db, primary});
            }
            if (validation.isFix()) {
                x.setDb(primary);
            }
        }
    }
}

