/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.miriam.MiriamLink;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.NucleicAcidRegionReference;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.BPCollections;
import org.biopax.paxtools.util.ClassFilterSet;

public final class Normalizer {
    private static final Log log = LogFactory.getLog(Normalizer.class);
    private SimpleIOHandler biopaxReader = new SimpleIOHandler(BioPAXLevel.L3);
    private String description = "";
    private boolean fixDisplayName;
    private String xmlBase;
    public static final String PROPERTY_NORMALIZER_URI_STRATEGY = "biopax.normalizer.uri.strategy";
    public static final String VALUE_NORMALIZER_URI_STRATEGY_SIMPLE = "simple";
    public static final String VALUE_NORMALIZER_URI_STRATEGY_MD5 = "md5";

    public Normalizer() {
        this.biopaxReader.mergeDuplicates(true);
        this.fixDisplayName = true;
        this.xmlBase = "";
    }

    public String normalize(String biopaxOwlData) {
        if (biopaxOwlData == null || biopaxOwlData.length() == 0) {
            throw new IllegalArgumentException("no data. " + this.description);
        }
        biopaxOwlData = biopaxOwlData.replaceAll("taxonXref", "xref");
        Model model = null;
        try {
            model = this.biopaxReader.convertFromOWL((InputStream)new ByteArrayInputStream(biopaxOwlData.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed! " + this.description, e);
        }
        if (model == null) {
            throw new IllegalArgumentException("Failed to create Model! " + this.description);
        }
        if (model.getLevel() != BioPAXLevel.L3) {
            log.info((Object)"Converting model to BioPAX Level3...");
            model = new LevelUpgrader().filter(model);
        }
        this.normalize(model);
        return this.convertToOWL(model);
    }

    private void normalizeXrefs(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        String xmlBase = this.getXmlBase(model);
        HashSet xrefs = new HashSet(model.getObjects(Xref.class));
        for (Xref ref : xrefs) {
            String idPart = null;
            if (ref.getId() != null) {
                idPart = ref.getId();
                if (ref.getIdVersion() != null) {
                    idPart = idPart + "_" + ref.getIdVersion();
                }
            }
            if (ref instanceof PublicationXref) {
                if (ref.getDb() == null || ref.getId() == null) {
                    continue;
                }
            } else if (ref instanceof RelationshipXref) {
                if (!ref.getRDFId().startsWith("http://identifiers.org/")) continue;
                RelationshipTypeVocabulary cv = ((RelationshipXref)ref).getRelationshipType();
                if (cv != null && !cv.getTerm().isEmpty()) {
                    idPart = idPart != null ? idPart + "_" + StringUtils.join((Collection)cv.getTerm(), (char)'_').toLowerCase() : StringUtils.join((Collection)cv.getTerm(), (char)'_').toLowerCase();
                }
            } else if (ref instanceof UnificationXref) {
                if (ref.getDb() == null || ref.getId() == null) continue;
                String db = ref.getDb();
                try {
                    db = MiriamLink.getName((String)ref.getDb());
                    if (db != null) {
                        ref.setDb(db);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (db.toUpperCase().startsWith("UNIPROT")) {
                    String isoformId;
                    if (Normalizer.uri(xmlBase, "UniProt Isoform", ref.getId(), ProteinReference.class).startsWith("http://identifiers.org/uniprot.isoform/")) {
                        ref.setDb("UniProt Isoform");
                        idPart = ref.getId();
                    } else if (ref.getIdVersion() != null && Normalizer.uri(xmlBase, "UniProt Isoform", isoformId = ref.getId() + "-" + ref.getIdVersion(), ProteinReference.class).startsWith("http://identifiers.org/uniprot.isoform/")) {
                        ref.setDb("UniProt Isoform");
                        ref.setId(isoformId);
                        ref.setIdVersion(null);
                        idPart = isoformId;
                    }
                }
            }
            map.put((BioPAXElement)ref, Normalizer.uri(xmlBase, ref.getDb(), idPart, ref.getModelInterface()));
        }
        map.doSubs();
    }

    public static String uri(String xmlBase, String dbName, String idPart, Class<? extends BioPAXElement> type) {
        if (type == null || dbName == null && idPart == null) {
            throw new IllegalArgumentException("'Either type' is null, or both dbName and idPart are nulls.");
        }
        if (dbName != null) {
            try {
                dbName = MiriamLink.getName((String)dbName);
                if (type.equals(PublicationXref.class) && "pubmed".equalsIgnoreCase(dbName) || type.equals(RelationshipTypeVocabulary.class) || EntityReference.class.isAssignableFrom(type)) {
                    return MiriamLink.getIdentifiersOrgURI((String)dbName, (String)idPart);
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("uri: not a standard db name or synonym: " + dbName), (Throwable)e);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (dbName != null) {
            sb.append(dbName.toLowerCase());
        }
        if (idPart != null) {
            if (dbName != null) {
                sb.append("_");
            }
            sb.append(idPart);
        }
        String localPart = sb.toString();
        String strategy = System.getProperty(PROPERTY_NORMALIZER_URI_STRATEGY, VALUE_NORMALIZER_URI_STRATEGY_MD5);
        localPart = VALUE_NORMALIZER_URI_STRATEGY_SIMPLE.equals(strategy) || Xref.class.isAssignableFrom(type) ? localPart.replaceAll("[^-\\w]", "_") : ModelUtils.md5hex((String)localPart);
        return (xmlBase != null ? xmlBase : "") + type.getSimpleName() + "_" + localPart;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void fixDisplayName(Model model) {
        log.info((Object)"Trying to auto-fix 'null' displayName...");
        for (Named e : model.getObjects(Named.class)) {
            if (e.getDisplayName() != null) continue;
            if (e.getStandardName() != null) {
                e.setDisplayName(e.getStandardName());
                log.info((Object)(e + " displayName auto-fix: " + e.getDisplayName() + ". " + this.description));
                continue;
            }
            if (e.getName().isEmpty()) continue;
            String dsp = (String)e.getName().iterator().next();
            for (String name : e.getName()) {
                if (name.length() >= dsp.length()) continue;
                dsp = name;
            }
            e.setDisplayName(dsp);
            log.info((Object)(e + " displayName auto-fix: " + dsp + ". " + this.description));
        }
        for (EntityReference er : model.getObjects(EntityReference.class)) {
            for (SimplePhysicalEntity spe : er.getEntityReferenceOf()) {
                if (spe.getDisplayName() != null && spe.getDisplayName().trim().length() != 0 || er.getDisplayName() == null || er.getDisplayName().trim().length() <= 0) continue;
                spe.setDisplayName(er.getDisplayName());
            }
        }
    }

    private String convertToOWL(Model model) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new SimpleIOHandler(model.getLevel()).convertToOWL(model, (OutputStream)out);
        return out.toString();
    }

    private List<UnificationXref> getUnificationXrefsSorted(XReferrable referrable) {
        ArrayList<UnificationXref> urefs = new ArrayList<UnificationXref>((Collection<UnificationXref>)new ClassFilterSet(referrable.getXref(), UnificationXref.class));
        for (UnificationXref ux : new ArrayList(urefs)) {
            if (ux.getDb() != null && ux.getId() != null) continue;
            log.warn((Object)("Won't consider the UnificationXref having NULL 'db' or 'id' property: " + ux + ", " + ux.getRDFId() + ". " + this.description));
            urefs.remove(ux);
        }
        Comparator<UnificationXref> comparator = new Comparator<UnificationXref>(){

            @Override
            public int compare(UnificationXref o1, UnificationXref o2) {
                String s1 = o1.getDb() + o1.getId();
                String s2 = o2.getDb() + o2.getId();
                return s1.compareTo(s2);
            }
        };
        Collections.sort(urefs, comparator);
        return urefs;
    }

    private UnificationXref getFirstUnificationXref(XReferrable bpe) {
        UnificationXref toReturn = null;
        String preferredDb = null;
        if (bpe instanceof ProteinReference) {
            preferredDb = "uniprot";
        } else if (bpe instanceof SmallMoleculeReference) {
            preferredDb = "chebi";
        } else if (bpe instanceof NucleicAcidReference || bpe instanceof NucleicAcidRegionReference) {
            preferredDb = "entrez";
        }
        List<UnificationXref> orderedUrefs = this.getUnificationXrefsSorted(bpe);
        if (preferredDb == null && !orderedUrefs.isEmpty()) {
            toReturn = (UnificationXref)orderedUrefs.iterator().next();
            return toReturn;
        }
        for (UnificationXref uref : orderedUrefs) {
            if (!uref.getDb().toLowerCase().startsWith(preferredDb) || uref.getId() == null) continue;
            toReturn = uref;
            break;
        }
        if (toReturn == null && bpe instanceof ProteinReference) {
            for (UnificationXref uref : orderedUrefs) {
                if (!uref.getDb().toLowerCase().startsWith("refseq") || uref.getId() == null) continue;
                toReturn = uref;
                break;
            }
        }
        return toReturn;
    }

    public void normalize(Model model) {
        if (model.getLevel() != BioPAXLevel.L3) {
            throw new IllegalArgumentException("Not Level3 model. Consider converting it first (e.g., with the PaxTools).");
        }
        log.info((Object)("Normalizing xrefs..." + this.description));
        this.normalizeXrefs(model);
        if (this.fixDisplayName) {
            log.info((Object)("Normalizing display names..." + this.description));
            this.fixDisplayName(model);
        }
        log.info((Object)("Normalizing CVs..." + this.description));
        this.normalizeCVs(model);
        log.info((Object)("Normalizing organisms..." + this.description));
        this.normalizeBioSources(model);
        log.info((Object)("Normalizing entity references..." + this.description));
        this.normalizeERs(model);
        log.info((Object)("Repairing..." + this.description));
        model.repair();
        log.info((Object)("Optional tasks (reasoning)..." + this.description));
    }

    private void normalizeCVs(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (ControlledVocabulary cv : model.getObjects(ControlledVocabulary.class)) {
            UnificationXref uref = this.getFirstUnificationXref((XReferrable)cv);
            if (uref != null) {
                map.put((BioPAXElement)cv, Normalizer.uri(this.xmlBase, uref.getDb(), uref.getId(), cv.getModelInterface()));
                continue;
            }
            if (!cv.getTerm().isEmpty()) {
                map.put((BioPAXElement)cv, Normalizer.uri(this.xmlBase, null, (String)cv.getTerm().iterator().next(), cv.getModelInterface()));
                continue;
            }
            log.info((Object)("Cannot normalize " + cv.getModelInterface().getSimpleName() + " : no unification xrefs nor terms found in " + cv.getRDFId() + ". " + this.description));
        }
        map.doSubs();
    }

    private void normalizeBioSources(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (BioSource bs : model.getObjects(BioSource.class)) {
            UnificationXref uref = this.getFirstUnificationXref((XReferrable)bs);
            if (uref != null && (uref.getDb().toLowerCase().contains("taxonomy") || uref.getDb().equalsIgnoreCase("newt"))) {
                String idPart = uref.getId();
                if (bs.getTissue() != null && !bs.getTissue().getTerm().isEmpty()) {
                    idPart = idPart + "_" + (String)bs.getTissue().getTerm().iterator().next();
                }
                if (bs.getCellType() != null && !bs.getCellType().getTerm().isEmpty()) {
                    idPart = idPart + "_" + (String)bs.getCellType().getTerm().iterator().next();
                }
                String uri = Normalizer.uri(this.xmlBase, uref.getDb(), idPart, BioSource.class);
                map.put((BioPAXElement)bs, uri);
                continue;
            }
            log.debug((Object)("Won't normalize BioSource : no taxonomy unification xref found in " + bs.getRDFId() + ". " + this.description));
        }
        map.doSubs();
    }

    private void normalizeERs(Model model) {
        NormalizerMap map = new NormalizerMap(model);
        for (EntityReference bpe : model.getObjects(EntityReference.class)) {
            if (bpe.getRDFId().startsWith("http://identifiers.org/")) {
                log.info((Object)("Skip already normalized: " + bpe.getRDFId()));
                continue;
            }
            UnificationXref uref = this.getFirstUnificationXref((XReferrable)bpe);
            if (uref != null) {
                String db = uref.getDb();
                String id = uref.getId();
                String uri = null;
                try {
                    uri = MiriamLink.getIdentifiersOrgURI((String)db, (String)id);
                }
                catch (Exception e) {
                    log.error((Object)("Cannot get a Miriam standard ID for " + bpe + " (" + bpe.getModelInterface().getSimpleName() + ") " + ", using " + db + ":" + id + ". " + e + ". "));
                    return;
                }
                if (uri == null) continue;
                map.put((BioPAXElement)bpe, uri);
                continue;
            }
            log.info((Object)("Cannot normalize EntityReference: no unification xrefs found in " + bpe.getRDFId() + ". " + this.description));
        }
        map.doSubs();
    }

    public static void autoName(Provenance pro) {
        if (!pro.getRDFId().startsWith("urn:miriam:") && !pro.getRDFId().startsWith("http://identifiers.org/") && pro.getName().isEmpty()) {
            log.info((Object)("Skipping: cannot normalize Provenance: " + pro.getRDFId()));
        } else {
            TreeSet<String> names = new TreeSet<String>();
            String key = null;
            key = pro.getRDFId().startsWith("urn:miriam:") || pro.getRDFId().startsWith("http://identifiers.org/") ? pro.getRDFId() : (pro.getStandardName() != null ? pro.getStandardName() : pro.getDisplayName());
            if (key != null) {
                try {
                    names.addAll(Arrays.asList(MiriamLink.getNames((String)key)));
                    pro.setStandardName(MiriamLink.getName((String)key));
                    String description = MiriamLink.getDataTypeDef((String)pro.getStandardName());
                    pro.addComment(description);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (names.isEmpty()) {
                for (String name : pro.getName()) {
                    try {
                        names.addAll(Arrays.asList(MiriamLink.getNames((String)name)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (!names.isEmpty()) {
                    pro.setStandardName(MiriamLink.getName((String)((String)names.iterator().next())));
                }
            }
            for (String name : names) {
                pro.addName(name);
            }
            if (pro.getDisplayName() == null) {
                pro.setDisplayName(pro.getStandardName());
            }
        }
    }

    public static String convertToLevel3(String biopaxData) {
        String toReturn = "";
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ByteArrayInputStream is = new ByteArrayInputStream(biopaxData.getBytes());
            SimpleIOHandler io = new SimpleIOHandler();
            io.mergeDuplicates(true);
            Model model = io.convertFromOWL((InputStream)is);
            if (model.getLevel() != BioPAXLevel.L3) {
                log.info((Object)("Converting to BioPAX Level3... " + model.getXmlBase()));
                model = new LevelUpgrader().filter(model);
                if (model != null) {
                    io.setFactory(model.getLevel().getDefaultFactory());
                    io.convertToOWL(model, (OutputStream)os);
                    toReturn = os.toString();
                }
            } else {
                toReturn = biopaxData;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert to BioPAX Level3", e);
        }
        return toReturn;
    }

    private String getXmlBase(Model modelToNormalize) {
        if (this.xmlBase != null && !this.xmlBase.isEmpty()) {
            return this.xmlBase;
        }
        return modelToNormalize.getXmlBase() != null ? modelToNormalize.getXmlBase() : "";
    }

    public boolean isFixDisplayName() {
        return this.fixDisplayName;
    }

    public void setFixDisplayName(boolean fixDisplayName) {
        this.fixDisplayName = fixDisplayName;
    }

    public String getXmlBase() {
        return this.xmlBase;
    }

    public void setXmlBase(String xmlBase) {
        this.xmlBase = xmlBase;
    }

    private static class NormalizerMap {
        final Model model;
        final Map<BioPAXElement, BioPAXElement> subs = BPCollections.I.createMap();
        final Map<String, BioPAXElement> uriToSub = BPCollections.I.createMap();
        final ShallowCopy copier;

        NormalizerMap(Model model) {
            this.model = model;
            this.copier = new ShallowCopy();
        }

        void put(BioPAXElement bpe, String newUri) {
            if (this.model.containsID(newUri)) {
                this.map(bpe, this.model.getByID(newUri));
            } else if (this.uriToSub.containsKey(newUri)) {
                this.map(bpe, this.uriToSub.get(newUri));
            } else {
                BioPAXElement copy = this.copier.copy(bpe, newUri);
                this.map(bpe, copy);
            }
        }

        void doSubs() {
            for (BioPAXElement e : this.subs.keySet()) {
                this.model.remove(e);
            }
            try {
                ModelUtils.replace((Model)this.model, this.subs);
            }
            catch (Exception e) {
                log.error((Object)"Failed to replace BioPAX elements.", (Throwable)e);
                return;
            }
            for (BioPAXElement e : this.subs.values()) {
                if (this.model.contains(e)) continue;
                this.model.add(e);
            }
            for (BioPAXElement e : this.model.getObjects()) {
                ModelUtils.fixDanglingInverseProperties((BioPAXElement)e, (Model)this.model);
            }
        }

        private void map(BioPAXElement bpe, BioPAXElement newBpe) {
            this.subs.put(bpe, newBpe);
            this.uriToSub.put(newBpe.getRDFId(), newBpe);
        }
    }
}

