/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.api.Validator;
import org.biopax.validator.api.ValidatorUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAspect {
    private static final Log log = LogFactory.getLog(AbstractAspect.class);
    @Autowired
    protected Validator validator;
    @Autowired
    protected ValidatorUtils utils;

    public void report(Object object, String errorCode, String reportedBy, boolean setFixed, Object ... msgArgs) {
        this.validator.report(object, errorCode, reportedBy, setFixed, msgArgs);
    }

    public void reportException(Throwable t, Object obj, String errorCode, String reportedBy, String details) {
        StringBuilder msg = new StringBuilder(t.toString());
        if (t instanceof XMLStreamException) {
            XMLStreamException ex = (XMLStreamException)t;
            msg.append("; ").append(ex.getLocation().toString());
        } else if ("exception".equals(errorCode)) {
            msg.append(" - stack:").append(AbstractAspect.getStackTrace(t)).append(" - ");
        }
        if (details != null) {
            msg.append("; ").append(details);
        }
        if (this.validator != null) {
            this.validator.report(obj, errorCode, reportedBy, false, msg.toString());
        } else {
            log.error((Object)("utils is null (not initialized?); skipping an intercepted 'syntax.error': " + msg.toString() + " reported by: " + reportedBy));
        }
    }

    private static String getStackTrace(Throwable aThrowable) {
        StringWriter strw = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strw);
        aThrowable.printStackTrace(printWriter);
        return strw.toString();
    }
}

