/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.api;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.Category;
import org.biopax.validator.api.beans.ErrorCaseType;
import org.biopax.validator.api.beans.ErrorType;
import org.biopax.validator.api.beans.Validation;
import org.biopax.validator.api.beans.ValidatorResponse;
import org.springframework.context.MessageSource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service
public class ValidatorUtils {
    private static final Log logger = LogFactory.getLog(ValidatorUtils.class);
    private Locale locale;
    private MessageSource messageSource;
    private static JAXBContext jaxbContext;
    private int maxErrors = Integer.MAX_VALUE;

    public ValidatorUtils() {
        this.locale = Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static Marshaller getMarshaller() {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            return marshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create Marshaller", e);
        }
    }

    public static Unmarshaller getUnmarshaller() {
        try {
            return jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to create Unmarshaller", e);
        }
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int max) {
        this.maxErrors = max;
    }

    public static void write(ValidatorResponse validatorResponse, Writer writer, Source xslt) {
        try {
            if (xslt != null) {
                Document doc = ValidatorUtils.asDocument(validatorResponse);
                DOMSource xmlSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory transFact = TransformerFactory.newInstance();
                Transformer trans = transFact.newTransformer(xslt);
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                trans.transform(xmlSource, result);
            } else {
                ValidatorUtils.getMarshaller().marshal((Object)validatorResponse, writer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot transform/serialize/write: " + validatorResponse, e);
        }
    }

    public static void write(Validation validationResult, Writer writer, Source xslt) {
        ValidatorResponse resp = new ValidatorResponse();
        resp.addValidationResult(validationResult);
        ValidatorUtils.write(resp, writer, xslt);
    }

    public static Document asDocument(ValidatorResponse validatorResponse) {
        DOMResult domResult = ValidatorUtils.marshal(validatorResponse);
        Document validation = (Document)domResult.getNode();
        return validation;
    }

    public static Element asElement(Validation validationResult) {
        DOMResult domResult = ValidatorUtils.marshal(validationResult);
        Element validation = (Element)domResult.getNode().getFirstChild();
        return validation;
    }

    protected static DOMResult marshal(Object obj) {
        DOMResult domResult = new DOMResult();
        try {
            ValidatorUtils.getMarshaller().marshal(obj, (Result)domResult);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot serialize object: " + obj, e);
        }
        return domResult;
    }

    public ErrorType createError(String objectName, String errorCode, String ruleName, String profile, boolean isFixed, Object ... msgArgs) {
        return ValidatorUtils.createError(this.messageSource, this.locale, objectName, errorCode, ruleName, profile, isFixed, msgArgs);
    }

    public static ErrorType createError(MessageSource messageSource, Locale locale, String objectName, String errorCode, String ruleName, String profile, boolean isFixed, Object ... msgArgs) {
        String category;
        if (objectName == null) {
            objectName = "null";
            logger.warn((Object)("Creating an error " + errorCode + " for Null object!"));
        }
        Behavior behavior = ValidatorUtils.getRuleBehavior(ruleName, profile, messageSource);
        ErrorType error = new ErrorType(errorCode, behavior);
        String commonMsg = messageSource != null ? messageSource.getMessage(errorCode + ".default", new Object[0], "No description.", locale) : "No description.";
        error.setMessage(commonMsg);
        String msg = messageSource != null ? messageSource.getMessage(errorCode, msgArgs, StringUtils.join((Object[])msgArgs, (String)"; "), locale).replaceAll("\r|\n+", " ") : StringUtils.join((Object[])msgArgs, (String)"; ");
        String string = category = messageSource != null ? messageSource.getMessage(errorCode + ".category", null, Category.INFORMATION.name(), locale) : null;
        if (category != null) {
            error.setCategory(Category.valueOf(category.trim().toUpperCase()));
        }
        ErrorCaseType errorCase = new ErrorCaseType(ruleName, objectName, msg);
        errorCase.setFixed(isFixed);
        error.addErrorCase(errorCase);
        return error;
    }

    public static String getHomeDir() throws IOException {
        FileSystemResource r = new FileSystemResource(ResourceUtils.getFile((String)"classpath:"));
        return r.createRelative("..").getFile().getCanonicalPath();
    }

    public Behavior getRuleBehavior(String ruleName, String profile) {
        return ValidatorUtils.getRuleBehavior(ruleName, profile, this.messageSource);
    }

    private static Behavior getRuleBehavior(String ruleName, String profile, MessageSource messageSource) {
        if (messageSource == null) {
            return Behavior.ERROR;
        }
        String value = messageSource.getMessage(ruleName + ".behavior", null, "ERROR", Locale.getDefault());
        if (profile != null && !profile.isEmpty()) {
            value = messageSource.getMessage(ruleName + ".behavior." + profile, null, value, Locale.getDefault());
        }
        return Behavior.valueOf(value.toUpperCase());
    }

    public String getRuleDescription(String ruleName) {
        String tip = this.messageSource.getMessage(ruleName, null, "", Locale.getDefault());
        tip = tip == null || "".equals(tip) ? "description is not found in the messages.properties file" : StringEscapeUtils.escapeHtml((String)tip);
        return tip;
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ValidatorResponse.class, Validation.class, ErrorCaseType.class, ErrorType.class, Behavior.class, Category.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to initialize the org.biopax.validator.result JAXB context!", e);
        }
    }
}

