/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.validator.api.beans;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.validator.api.beans.Behavior;
import org.biopax.validator.api.beans.Category;
import org.biopax.validator.api.beans.ErrorCaseType;
import org.biopax.validator.api.beans.ErrorType;

@XmlType(name="Validation")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Validation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Validation.class);
    @XmlTransient
    private Object model;
    @XmlTransient
    private final Set<Object> objects;
    @XmlTransient
    private final Properties properties;
    @XmlTransient
    private final Identifier idCalc;
    @XmlElement(required=false)
    private String modelData;
    @XmlElement
    private final Set<ErrorType> error = new TreeSet<ErrorType>();
    @XmlAttribute(required=false)
    private String description = "unknown";
    @XmlElement
    private final Set<String> comment;
    @XmlAttribute
    private int notFixedProblems = 0;
    @XmlAttribute
    private int notFixedErrors = 0;
    @XmlAttribute
    private int totalProblemsFound = 0;
    @XmlAttribute
    private boolean fix = false;
    @XmlAttribute(required=false)
    private Behavior threshold;
    @XmlAttribute(required=false)
    private int maxErrors;
    @XmlAttribute(required=false)
    private String profile = null;
    @XmlAttribute
    private String summary;

    public Validation(Identifier idCalculator) {
        this.objects = Collections.newSetFromMap(new ConcurrentHashMap());
        this.comment = new HashSet<String>();
        this.threshold = Behavior.WARNING;
        this.maxErrors = Integer.MAX_VALUE;
        this.properties = new Properties();
        this.idCalc = idCalculator != null ? idCalculator : new Identifier(){

            @Override
            public String identify(Object obj) {
                return String.valueOf(obj);
            }
        };
    }

    public Validation() {
        this(null);
    }

    public Validation(Identifier idCalculator, String description, boolean autoFix, Behavior errorLevel, int maxErrors, String profile) {
        this(idCalculator);
        this.setDescription(description);
        this.fix = autoFix;
        if (errorLevel != null) {
            this.threshold = errorLevel;
        }
        if (maxErrors < 0) {
            throw new IllegalArgumentException("Illegal value for maxErrors: " + maxErrors);
        }
        this.maxErrors = maxErrors;
        if (profile != null && !profile.isEmpty()) {
            this.profile = profile;
        }
    }

    @XmlTransient
    public Object getModel() {
        return this.model;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public Collection<ErrorType> getError() {
        return this.error;
    }

    public synchronized void setError(Collection<ErrorType> errors) {
        this.error.clear();
        this.error.addAll(errors);
    }

    public String getModelData() {
        return this.modelData;
    }

    public void setModelData(String modelData) {
        this.modelData = modelData;
    }

    @XmlTransient
    public String getModelDataHtmlEscaped() {
        return this.modelData != null ? StringEscapeUtils.escapeHtml((String)this.modelData).replaceAll(System.getProperty("line.separator"), System.getProperty("line.separator") + "<br/>") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void addError(ErrorType e) {
        int numNotFixedErrors = this.countErrors(null, null, null, null, true, true);
        if (this.isMaxErrorsSet() && numNotFixedErrors >= this.getMaxErrors()) {
            log.info((Object)("Won't save the case: max. errors limit exceeded for " + this.getDescription()));
            return;
        }
        switch (this.threshold) {
            case IGNORE: {
                return;
            }
            case ERROR: {
                if (e.getType() != Behavior.WARNING) break;
                return;
            }
        }
        Validation validation = this;
        synchronized (validation) {
            if (this.error.contains(e)) {
                ErrorType et;
                Iterator<ErrorType> iterator = this.error.iterator();
                do {
                    if (!iterator.hasNext()) return;
                } while (!(et = iterator.next()).equals(e));
                et.addCases(e.getErrorCase());
            } else {
                this.error.add(e);
            }
            return;
        }
    }

    public synchronized void removeError(ErrorType e) {
        this.error.remove(e);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setComment(Collection<String> comments) {
        this.comment.clear();
        this.comment.addAll(comments);
    }

    public void addComment(String comment) {
        this.comment.add(comment);
    }

    public Collection<String> getComment() {
        return this.comment;
    }

    public synchronized String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String toString() {
        return super.toString() + " (" + this.getDescription() + "; " + this.getSummary() + ")";
    }

    public ErrorType findErrorType(String code, Behavior type) {
        return this.findErrorType(new ErrorType(code, type));
    }

    private ErrorType findErrorType(ErrorType errorType) {
        if (this.getError().contains(errorType)) {
            for (ErrorType et : this.getError()) {
                if (!et.equals(errorType)) continue;
                return et;
            }
        }
        return null;
    }

    private ErrorCaseType findErrorCase(ErrorType errorType, ErrorCaseType errCase) {
        ErrorType etype = this.findErrorType(errorType);
        if (etype != null) {
            ErrorCaseType ecase = etype.findErrorCase(errCase);
            return ecase;
        }
        return null;
    }

    public int countErrors(String forObject, String reportedBy, String code, Category category, boolean ignoreWarnings, boolean ignoreFixed) {
        int count = 0;
        for (ErrorType et : this.getError()) {
            if (ignoreWarnings && et.getType() == Behavior.WARNING || code != null && !code.equalsIgnoreCase(et.getCode()) || category != null && category != et.getCategory()) continue;
            count += et.countErrors(forObject, reportedBy, ignoreFixed);
        }
        return count;
    }

    @XmlTransient
    public Set<Object> getObjects() {
        return this.objects;
    }

    public boolean isFix() {
        return this.fix;
    }

    protected void setFix(boolean fix) {
        this.fix = fix;
    }

    public Behavior getThreshold() {
        return this.threshold;
    }

    protected void setThreshold(Behavior threshold) {
        this.threshold = threshold;
    }

    public int getTotalProblemsFound() {
        return this.totalProblemsFound;
    }

    public void setTotalProblemsFound(int n) {
        this.totalProblemsFound = n;
    }

    public synchronized int getNotFixedProblems() {
        return this.notFixedProblems;
    }

    public void setNotFixedProblems(int n) {
        this.notFixedProblems = n;
    }

    public synchronized int getNotFixedErrors() {
        return this.notFixedErrors;
    }

    public void setNotFixedErrors(int n) {
        this.notFixedErrors = n;
    }

    public void setFixed(String objectId, String rule, String errCode, String newMsg) {
        Behavior type = Behavior.WARNING;
        ErrorCaseType ect = this.findErrorCase(new ErrorType(errCode, type), new ErrorCaseType(rule, objectId, null));
        if (ect == null) {
            type = Behavior.ERROR;
            ect = this.findErrorCase(new ErrorType(errCode, type), new ErrorCaseType(rule, objectId, null));
        }
        if (ect != null && !ect.isFixed()) {
            ect.setFixed(true);
            if (newMsg != null && !"".equals(newMsg.trim())) {
                ect.setMessage(newMsg);
            }
        }
    }

    public int getMaxErrors() {
        return this.isMaxErrorsSet() ? this.maxErrors : 0;
    }

    protected void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @XmlTransient
    public boolean isMaxErrorsSet() {
        return this.maxErrors > 0 && this.maxErrors < Integer.MAX_VALUE;
    }

    @XmlTransient
    public Properties getProperties() {
        return this.properties;
    }

    public String getProfile() {
        return this.profile;
    }

    protected void setProfile(String profile) {
        this.profile = profile;
    }

    public String identify(Object obj) {
        return this.idCalc.identify(obj);
    }

    public static interface Identifier {
        public String identify(Object var1);
    }
}

