/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.ols.impl;

import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.ols.Annotation;
import org.biopax.ols.DbXref;
import org.biopax.ols.Loader;
import org.biopax.ols.Ontology;
import org.biopax.ols.Parser;
import org.biopax.ols.Term;
import org.biopax.ols.TermPath;
import org.biopax.ols.TermRelationship;
import org.biopax.ols.TermSynonym;
import org.biopax.ols.impl.AnnotationBean;
import org.biopax.ols.impl.DbXrefBean;
import org.biopax.ols.impl.OntologyBean;
import org.biopax.ols.impl.TermBean;
import org.biopax.ols.impl.TermPathBean;
import org.biopax.ols.impl.TermRelationshipBean;
import org.biopax.ols.impl.TermSynonymBean;
import org.obo.datamodel.Dbxref;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.Namespace;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.PropertyValue;
import org.obo.datamodel.Synonym;
import org.obo.datamodel.SynonymType;
import org.obo.datamodel.TermSubset;

public abstract class BaseOBO2AbstractLoader
implements Loader {
    protected static Log logger = LogFactory.getLog(BaseOBO2AbstractLoader.class);
    protected HashMap<String, Term> ontologyTerms = new HashMap(5000);
    protected String ONTOLOGY_DEFINITION;
    protected String FULL_NAME;
    protected String SHORT_NAME;
    protected String QUERY_URL = null;
    protected String SOURCE_URL = null;
    protected OntologyBean ontBean = null;
    protected TermBean IS_A = null;
    protected TermBean PART_OF = null;
    protected TermBean DEVELOPS_FROM = null;
    protected TermBean ALT_ID = null;
    protected TermBean EXACT = null;
    protected TermBean NARROW = null;
    protected TermBean BROAD = null;
    protected TermBean RELATED = null;
    protected TermBean SYNONYM = null;
    protected final HashSet<String> PART_OF_SET = new HashSet();
    protected final HashSet<String> IS_A_SET = new HashSet();
    protected final HashSet<String> DEV_FROM_SET = new HashSet();
    private HashMap<String, Term> unknown_relations = new HashMap();
    private TreeSet<String> rootTerms = new TreeSet();
    protected Parser parser;
    private Set<String> MOD_NUMERIC_ANNOTATIONS = null;
    private Set<String> MOD_STRING_ANNOTATIONS = null;
    protected static final boolean BATCH_MODE = true;
    protected boolean useGreedy = false;

    protected void setParser(Parser parser) {
        this.parser = parser;
    }

    protected void setUseGreedy(boolean useGreedy) {
        this.useGreedy = useGreedy;
    }

    protected Collection<String> getRootTerms() {
        HashSet<String> retval = new HashSet<String>();
        if (this.parser != null) {
            Set<OBOObject> roots = this.parser.getRootTerms(this.useGreedy);
            if (roots != null) {
                for (OBOObject root : roots) {
                    retval.add(this.safeTrim(root.getID()));
                }
            }
        } else {
            throw new IllegalStateException("Parser has not been initialized. Did you run configure()?");
        }
        return retval;
    }

    protected void process() {
        HashSet<OBOObject> terms = new HashSet<OBOObject>();
        if (this.parser == null) {
            throw new IllegalStateException("parser has not been initialized. Did you run configure()?");
        }
        Set<OBOObject> toAdd = this.parser.getTerms();
        if (toAdd != null) {
            terms.addAll(toAdd);
        }
        this.initializeCommonObjects();
        logger.info((Object)("Total Terms to process: " + terms.size()));
        int count = 0;
        for (Object e : terms) {
            ++count;
            if (e instanceof OBOObject) {
                this.processTerm((OBOObject)e);
                if (count % 1000 != 0) continue;
                logger.debug((Object)("Terms Processed: " + count));
                continue;
            }
            logger.info((Object)("Ignored object: " + e.toString()));
        }
        logger.info((Object)"Term processing done");
        logger.info((Object)"Creating relationships");
        count = 0;
        for (Object e : terms) {
            ++count;
            if (e instanceof OBOObject) {
                this.processTermRelationships((OBOObject)e);
                if (count % 1000 != 0) continue;
                logger.debug((Object)("Relationships Processed: " + count));
                continue;
            }
            logger.info((Object)("Ignored object: " + e.toString()));
        }
        logger.info((Object)"Relationship processing done");
        this.ontBean.setTerms(this.ontologyTerms.values());
    }

    protected void initializeCommonObjects() {
        Collection synonymTypes;
        String version;
        if (this.parser != null) {
            version = this.parser.getSession().getCurrentHistory().getVersion();
            if (version == null) {
                java.util.Date tmp = this.parser.getSession().getCurrentHistory().getDate();
                version = tmp != null ? tmp.toString() : new java.util.Date().toString();
            }
        } else {
            version = new java.util.Date().toString();
        }
        this.ontBean = new OntologyBean();
        if (this.ONTOLOGY_DEFINITION != null && this.ONTOLOGY_DEFINITION.length() > 2000) {
            logger.warn((Object)"ontology definition longer than allowed database column length - truncating");
            this.ONTOLOGY_DEFINITION = this.ONTOLOGY_DEFINITION.substring(0, 2000);
        }
        this.ontBean.setDefinition(this.ONTOLOGY_DEFINITION);
        if (this.FULL_NAME != null && this.FULL_NAME.length() > 128) {
            logger.warn((Object)"ontology full name longer than allowed database column length - truncating");
            this.FULL_NAME = this.FULL_NAME.substring(0, 128);
        }
        this.ontBean.setFullOntologyName(this.FULL_NAME);
        this.ontBean.setLoadDate(new Date(GregorianCalendar.getInstance().getTime().getTime()));
        if (this.SHORT_NAME != null && this.SHORT_NAME.length() > 32) {
            logger.warn((Object)"ontology short name longer than allowed database column length - truncating");
            this.SHORT_NAME = this.SHORT_NAME.substring(0, 32);
        }
        this.ontBean.setShortOntologyName(this.SHORT_NAME);
        if (version != null && version.length() > 128) {
            logger.warn((Object)"ontology version longer than allowed database column length - truncating");
            version = version.substring(0, 128);
        }
        this.ontBean.setVersion(version);
        this.ontBean.setFullyLoaded(false);
        if (this.QUERY_URL != null && this.QUERY_URL.length() > 255) {
            logger.warn((Object)"ontology query url longer than allowed database column length - truncating");
            this.QUERY_URL = this.QUERY_URL.substring(0, 255);
        }
        this.ontBean.setQueryURL(this.QUERY_URL);
        if (this.SOURCE_URL != null && this.SOURCE_URL.length() > 255) {
            logger.warn((Object)"ontology source url longer than allowed database column length - truncating");
            this.SOURCE_URL = this.SOURCE_URL.substring(0, 255);
        }
        this.ontBean.setSourceURL(this.SOURCE_URL);
        this.ontologyTerms.clear();
        this.IS_A_SET.clear();
        this.IS_A_SET.add("is_a");
        this.IS_A_SET.add("is_a".toUpperCase());
        this.IS_A_SET.add("isa");
        this.IS_A_SET.add("ISA");
        this.IS_A_SET.add("OBO_REL:is_a");
        this.PART_OF_SET.clear();
        this.PART_OF_SET.add("part_of");
        this.PART_OF_SET.add("part_of".toUpperCase());
        this.PART_OF_SET.add("partof");
        this.PART_OF_SET.add("PARTOF");
        this.PART_OF_SET.add("OBO_REL:part_of");
        this.PART_OF_SET.add("is_part_of");
        this.DEV_FROM_SET.clear();
        this.DEV_FROM_SET.add("develops_from");
        this.DEV_FROM_SET.add("develops_from".toUpperCase());
        this.DEV_FROM_SET.add("DERIVED/DEVELOPS_FROM");
        this.MOD_NUMERIC_ANNOTATIONS = new HashSet<String>();
        this.MOD_NUMERIC_ANNOTATIONS.add("DiffAvg");
        this.MOD_NUMERIC_ANNOTATIONS.add("DiffMono");
        this.MOD_NUMERIC_ANNOTATIONS.add("MassAvg");
        this.MOD_NUMERIC_ANNOTATIONS.add("MassMono");
        this.MOD_STRING_ANNOTATIONS = new HashSet<String>();
        this.MOD_STRING_ANNOTATIONS.add("DiffFormula");
        this.MOD_STRING_ANNOTATIONS.add("Formula");
        this.MOD_STRING_ANNOTATIONS.add("Source");
        this.MOD_STRING_ANNOTATIONS.add("Origin");
        this.MOD_STRING_ANNOTATIONS.add("TermSpec");
        this.IS_A = this.initializeTermBean("is_a", "relation_type");
        this.ontologyTerms.put(this.IS_A.getIdentifier(), this.IS_A);
        this.PART_OF = this.initializeTermBean("part_of", "relation_type");
        this.ontologyTerms.put(this.PART_OF.getIdentifier(), this.PART_OF);
        this.DEVELOPS_FROM = this.initializeTermBean("develops_from", "relation_type");
        this.ontologyTerms.put(this.DEVELOPS_FROM.getIdentifier(), this.DEVELOPS_FROM);
        this.ALT_ID = this.initializeTermBean("alt_id", "synonym_type");
        this.ontologyTerms.put(this.ALT_ID.getIdentifier(), this.ALT_ID);
        this.EXACT = this.initializeTermBean("exact", "synonym_type");
        this.ontologyTerms.put(this.EXACT.getIdentifier(), this.EXACT);
        this.NARROW = this.initializeTermBean("narrow", "synonym_type");
        this.ontologyTerms.put(this.NARROW.getIdentifier(), this.NARROW);
        this.BROAD = this.initializeTermBean("broad", "synonym_type");
        this.ontologyTerms.put(this.BROAD.getIdentifier(), this.BROAD);
        this.RELATED = this.initializeTermBean("related", "synonym_type");
        this.ontologyTerms.put(this.RELATED.getIdentifier(), this.RELATED);
        this.SYNONYM = this.initializeTermBean("synonym", "synonym_type");
        this.ontologyTerms.put(this.SYNONYM.getIdentifier(), this.SYNONYM);
        if (this.parser != null && (synonymTypes = this.parser.getSession().getSynonymTypes()) != null && !synonymTypes.isEmpty()) {
            for (SynonymType st : synonymTypes) {
                this.ontologyTerms.put(st.getID(), this.initializeTermBean(st.getName(), this.SHORT_NAME + ":" + st.getID(), this.getSynonymTypeDef(st.getScope())));
            }
        }
        this.rootTerms.clear();
        if (this.parser != null) {
            this.rootTerms.addAll(this.getRootTerms());
        }
    }

    private TermBean initializeTermBean(String name, String def) {
        if (name != null && !"".equals(name.trim())) {
            TermBean bean = new TermBean();
            bean.setName(name.trim());
            bean.setIdentifier(this.SHORT_NAME + ":" + name.toUpperCase().trim());
            bean.setDefinition(this.safeTrim(def));
            bean.setParentOntology(this.ontBean);
            bean.setTermPk(bean.getIdentifier() + this.SHORT_NAME + "0");
            return bean;
        }
        throw new IllegalArgumentException("Can't have a non-null term name!");
    }

    protected TermBean initializeTermBean(String name, String accession, String def) {
        if (accession != null && !"".equals(accession.trim())) {
            TermBean bean = this.initializeTermBean(name, def);
            bean.setIdentifier(accession.trim());
            bean.setTermPk(bean.getIdentifier() + this.SHORT_NAME + "0");
            return bean;
        }
        throw new IllegalArgumentException("Can't have a non-null term name!");
    }

    protected void processTerm(OBOObject obj) {
        Namespace nspace;
        if (obj.getID().startsWith("obo:")) {
            logger.debug((Object)("bogus term: " + obj.getID()));
            return;
        }
        TermBean trm = new TermBean();
        trm.setTermPk(this.safeTrim(obj.getID()) + this.SHORT_NAME + "0");
        if (trm.getTermPk().length() > 255) {
            throw new IllegalStateException("term PK longer than allowed database column length: " + trm.getTermPk());
        }
        trm.setDefinition(this.safeTrim(obj.getDefinition()));
        if (trm.getDefinition() != null && trm.getDefinition().length() > 4000) {
            logger.warn((Object)("term definition longer than allowed database column length - truncating" + trm.getIdentifier()));
            trm.setDefinition(trm.getDefinition().substring(0, 4000));
        }
        trm.setIdentifier(this.safeTrim(obj.getID()));
        if (trm.getIdentifier() != null && trm.getIdentifier().length() > 255) {
            logger.warn((Object)("term identifier longer than allowed database column length - truncating" + trm.getIdentifier()));
            trm.setIdentifier(trm.getIdentifier().substring(0, 255));
        }
        if (this.rootTerms.contains(this.safeTrim(obj.getID()))) {
            trm.setRootTerm(true);
            logger.info((Object)(obj.getID() + " is a root term"));
        }
        trm.setName(this.safeTrim(obj.getName()));
        if (trm.getName() != null && trm.getName().length() > 2000) {
            logger.warn((Object)("term name longer than allowed database column length - truncating" + trm.getIdentifier()));
            trm.setName(trm.getName().substring(0, 2000));
        }
        if ((nspace = obj.getNamespace()) != null) {
            trm.setNamespace(this.safeTrim(nspace.getID()));
            if (trm.getNamespace() != null && trm.getNamespace().length() > 255) {
                logger.warn((Object)("term namespace longer than allowed database column length - truncating" + trm.getIdentifier()));
                trm.setNamespace(trm.getNamespace().substring(0, 255));
            }
        }
        trm.setObsolete(obj.isObsolete());
        trm.setParentOntology(this.ontBean);
        trm.setSynonyms(this.processSynonyms(obj, trm));
        trm.setXrefs(this.processXrefs(obj, trm));
        trm.setAnnotations(this.processAnnotations(obj, trm));
        int nbChild = 0;
        if (obj.getChildren() != null) {
            nbChild = obj.getChildren().size();
        }
        if (nbChild > 0) {
            trm.setLeaf(false);
        } else {
            trm.setLeaf(true);
        }
        this.ontologyTerms.put(trm.getIdentifier(), trm);
    }

    private Collection<Annotation> processAnnotations(OBOObject obj, TermBean trm) {
        ArrayList<Annotation> retval = new ArrayList<Annotation>();
        String comment = this.safeTrim(obj.getComment());
        if (comment != null) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationStringValue(comment);
            annot.setAnnotationType("comment");
            if (comment != null && comment.length() > 2000) {
                logger.warn((Object)("annotation comment longer than allowed database column length - truncating " + trm.getIdentifier()));
                annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
            }
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set considers = obj.getConsiderReplacements();
        for (Object obsolete : considers) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("consider replacement");
            String val = obsolete.getID();
            if (obsolete.getName() != null) {
                val = val + ": " + obsolete.getName();
            }
            annot.setAnnotationStringValue(val);
            if (val != null && val.length() > 2000) {
                logger.warn((Object)("annotation value longer than allowed database column length - truncating " + trm.getIdentifier()));
                annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
            }
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set replacers = obj.getReplacedBy();
        for (Object replacedby : replacers) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("replaced by");
            String val = replacedby.getID();
            if (replacedby.getName() != null) {
                val = val + ": " + replacedby.getName();
            }
            annot.setAnnotationStringValue(val);
            if (val != null && val.length() > 2000) {
                logger.warn((Object)("annotation value longer than allowed database column length - truncating " + trm.getIdentifier()));
                annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
            }
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set subsets = obj.getSubsets();
        for (TermSubset subset : subsets) {
            AnnotationBean annot = new AnnotationBean();
            annot.setAnnotationType("subset_" + subset.getName());
            String val = subset.getDesc();
            annot.setAnnotationStringValue(val);
            if (val != null && val.length() > 2000) {
                logger.warn((Object)("annotation value longer than allowed database column length - truncating " + trm.getIdentifier()));
                annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
            }
            annot.setParentTerm(trm);
            retval.add(annot);
        }
        Set propVal = obj.getPropertyValues();
        for (PropertyValue pv : propVal) {
            AnnotationBean annot = new AnnotationBean();
            try {
                if (pv.getValue() == null) {
                    logger.warn((Object)("Error parsing property_value - Ignoring null value: " + pv.toString()));
                    continue;
                }
                String tmpStr = pv.getValue();
                int ndx = tmpStr.indexOf(32);
                if (ndx > 0) {
                    if ((tmpStr = tmpStr.substring(0, ndx).trim()).endsWith(":")) {
                        tmpStr = tmpStr.substring(0, tmpStr.length() - 1);
                    }
                    logger.debug((Object)("Setting property type: " + tmpStr));
                    annot.setAnnotationType(tmpStr.trim());
                    if (annot.getAnnotationType() != null && annot.getAnnotationType().length() > 2000) {
                        logger.warn((Object)("annotation type longer than allowed database column length - truncating " + trm.getIdentifier()));
                        annot.setAnnotationType(annot.getAnnotationType().substring(0, 2000));
                    }
                    tmpStr = pv.getValue();
                    if ((ndx = (tmpStr = tmpStr.substring(ndx + 1)).indexOf("xsd:")) > 0) {
                        tmpStr = tmpStr.substring(0, ndx);
                    }
                    if ((tmpStr = tmpStr.trim()).startsWith("\"") && tmpStr.endsWith("\"")) {
                        tmpStr = tmpStr.substring(1, tmpStr.length() - 1);
                    }
                    logger.debug((Object)("Setting property value: " + tmpStr.trim()));
                    annot.setAnnotationStringValue(tmpStr.trim());
                    if (tmpStr != null && tmpStr.length() > 2000) {
                        logger.warn((Object)("annotation value longer than allowed database column length - truncating " + trm.getIdentifier()));
                        annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
                    }
                } else {
                    annot.setAnnotationType(pv.getProperty());
                    if (pv.getProperty() != null && pv.getProperty().length() > 2000) {
                        logger.warn((Object)("annotation type longer than allowed database column length - truncating " + trm.getIdentifier()));
                        annot.setAnnotationType(annot.getAnnotationType().substring(0, 2000));
                    }
                    annot.setAnnotationStringValue(pv.getValue());
                    if (pv.getValue() != null && pv.getValue().length() > 2000) {
                        logger.warn((Object)("annotation value longer than allowed database column length - truncating " + trm.getIdentifier()));
                        annot.setAnnotationStringValue(annot.getAnnotationStringValue().substring(0, 2000));
                    }
                }
                annot.setParentTerm(trm);
            }
            catch (RuntimeException re) {
                logger.warn((Object)("Error parsing property_value - Ignoring : " + pv.toString()));
                logger.debug((Object)("pv.getProperty() = " + pv.getProperty()));
                logger.debug((Object)("pv.getValue() = " + pv.getValue()));
                continue;
            }
            retval.add(annot);
        }
        if ("MOD".equals(this.SHORT_NAME)) {
            for (Object xrObj : obj.getDbxrefs()) {
                AnnotationBean annot;
                Dbxref xref = (Dbxref)xrObj;
                if (this.MOD_STRING_ANNOTATIONS.contains(this.safeTrim(xref.getDatabase()))) {
                    annot = new AnnotationBean();
                    annot.setAnnotationType(this.safeTrim(xref.getDatabase()));
                    annot.setAnnotationStringValue(this.safeTrim(xref.getDesc()));
                    annot.setParentTerm(trm);
                    retval.add(annot);
                    continue;
                }
                if (!this.MOD_NUMERIC_ANNOTATIONS.contains(this.safeTrim(xref.getDatabase()))) continue;
                annot = new AnnotationBean();
                annot.setAnnotationType(this.safeTrim(xref.getDatabase()));
                annot.setAnnotationDoubleValue(this.safeTrim(xref.getDesc()));
                annot.setParentTerm(trm);
                retval.add(annot);
            }
        }
        return retval;
    }

    private Collection<DbXref> processXrefs(OBOObject obj, TermBean trm) {
        Dbxref xref;
        HashSet<DbXref> retval = new HashSet<DbXref>();
        for (Object xrObj : obj.getDbxrefs()) {
            xref = (Dbxref)xrObj;
            if (!"MOD".equals(this.SHORT_NAME)) {
                retval.add(this.createDbXref(xref, 3));
                continue;
            }
            if (this.MOD_STRING_ANNOTATIONS.contains(this.safeTrim(xref.getDatabase())) || this.MOD_NUMERIC_ANNOTATIONS.contains(this.safeTrim(xref.getDatabase()))) continue;
            retval.add(this.createDbXref(xref, 3));
        }
        for (Object xrObj : obj.getDefDbxrefs()) {
            xref = (Dbxref)xrObj;
            retval.add(this.createDbXref(xref, 2));
        }
        return retval;
    }

    private DbXref createDbXref(Dbxref xref, int xrefType) {
        DbXrefBean retval = new DbXrefBean();
        retval.setDbName(this.safeTrim(xref.getDatabase()));
        if (retval.getDbName() != null && retval.getDbName().length() > 255) {
            logger.warn((Object)("dbxref dbname longer than allowed database column length - truncating " + retval.getDbName()));
            retval.setDbName(retval.getDbName().substring(0, 255));
        }
        if (xref.getDatabaseID() != null && !xref.getID().trim().equals("none")) {
            retval.setAccession(this.safeTrim(xref.getDatabaseID()));
            if (retval.getAccession() != null && retval.getAccession().length() > 256) {
                System.out.println("retval.getAccession().length() = " + retval.getAccession().length());
                logger.warn((Object)("dbxref accession longer than allowed database column length: " + retval.getAccession()));
                retval.setAccession(retval.getAccession().substring(0, 256));
            }
        }
        if (xref.getDesc() != null && !xref.getDesc().trim().equals("none")) {
            retval.setDescription(this.safeTrim(xref.getDesc()));
            if (retval.getDescription() != null && retval.getDescription().length() > 2000) {
                logger.warn((Object)("dbxref description longer than allowed database column length: " + retval.getDescription()));
                retval.setDescription(retval.getDescription().substring(0, 2000));
            }
        }
        retval.setXrefType(xrefType);
        return retval;
    }

    private void processTermRelationships(OBOObject obj) {
        if (obj.getID().startsWith("obo:")) {
            logger.debug((Object)("bogus term: " + obj.getID()));
            return;
        }
        TermBean trm = (TermBean)this.ontologyTerms.get(this.safeTrim(obj.getID()));
        trm.setRelationships(this.processRelationships(obj, trm));
        trm.setPaths(this.processPaths(obj, trm));
        this.ontologyTerms.put(trm.getIdentifier(), trm);
    }

    private Collection<TermRelationship> processRelationships(OBOObject obj, TermBean trm) {
        HashSet<TermRelationship> retval = new HashSet<TermRelationship>();
        Collection children = obj.getChildren();
        for (Link lnk : children) {
            Term childTrm = this.ontologyTerms.get(this.safeTrim(lnk.getChild().getID()));
            if (childTrm != null) {
                TermRelationshipBean trb = new TermRelationshipBean();
                trb.setSubjectTerm(childTrm);
                trb.setObjectTerm(trm);
                if (this.IS_A_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.IS_A);
                } else if (this.PART_OF_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.PART_OF);
                } else if (this.DEV_FROM_SET.contains(lnk.getType().getID())) {
                    trb.setPredicateTerm(this.DEVELOPS_FROM);
                } else {
                    TermBean otherRelation = this.getUnknownRelationTermBean(lnk.getType().getID());
                    if (otherRelation != null) {
                        trb.setPredicateTerm(otherRelation);
                    } else {
                        logger.warn((Object)("Unable to create unknown relation type: >" + lnk.getType().getID() + "<"));
                        continue;
                    }
                }
                trb.setParentOntology(this.ontBean);
                retval.add(trb);
                continue;
            }
            logger.debug((Object)("No object term found for link: " + lnk.toString()));
        }
        return retval;
    }

    protected TermBean getUnknownRelationTermBean(String relationType) {
        TermBean retval = null;
        if (relationType != null && (retval = (TermBean)this.unknown_relations.get(relationType.trim().toUpperCase())) == null) {
            retval = this.initializeTermBean(relationType.trim(), "relation_type");
            logger.info((Object)("Created unkonwn relation type: " + relationType));
            this.unknown_relations.put(relationType.trim().toUpperCase(), retval);
            this.ontologyTerms.put(retval.getIdentifier(), retval);
        }
        return retval;
    }

    private Collection<TermPath> processPaths(OBOObject obj, TermBean trm) {
        HashSet<TermPath> retval = new HashSet<TermPath>();
        HashMap<String, Integer> paths = this.parser.computeChildPaths(1, this.IS_A_SET, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 1, this.IS_A, trm));
        HashSet<String> traversingSet = new HashSet<String>();
        traversingSet.addAll(this.PART_OF_SET);
        traversingSet.addAll(this.IS_A_SET);
        paths = this.parser.computeChildPaths(1, traversingSet, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 2, this.PART_OF, trm));
        traversingSet.clear();
        traversingSet.addAll(this.DEV_FROM_SET);
        traversingSet.addAll(this.IS_A_SET);
        paths = this.parser.computeChildPaths(1, traversingSet, (LinkedObject)obj);
        retval.addAll(this.createTermPathBeans(paths, 3, this.DEVELOPS_FROM, trm));
        return retval;
    }

    private Collection<TermPath> createTermPathBeans(HashMap<String, Integer> paths, int relationTypeId, TermBean relationBean, TermBean trm) {
        HashSet<TermPath> retval = new HashSet<TermPath>();
        for (String termId : paths.keySet()) {
            int distance = paths.get(termId);
            Term objTrm = this.ontologyTerms.get(termId);
            if (objTrm != null) {
                TermPathBean tpb = new TermPathBean();
                tpb.setDistance(distance);
                tpb.setSubjectTerm(objTrm);
                tpb.setObjectTerm(trm);
                tpb.setPredicateTerm(relationBean);
                tpb.setRelationshipTypeId(relationTypeId);
                tpb.setParentOntology(this.ontBean);
                retval.add(tpb);
                continue;
            }
            logger.debug((Object)("No object term found for term path: " + trm.getIdentifier() + "->" + termId));
        }
        return retval;
    }

    private String getSynonymTypeDef(int scope) {
        switch (scope) {
            case 1: {
                return "Exact synonym type";
            }
            case 2: {
                return "Narrow synonym type";
            }
            case 3: {
                return "Broad synonym type";
            }
            case 0: {
                return "Related synonym type";
            }
        }
        return "Unknown synonym type";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<TermSynonym> processSynonyms(OBOObject obj, TermBean trm) {
        TermSynonymBean tsb;
        HashSet<TermSynonym> retval = new HashSet<TermSynonym>();
        Set syns = obj.getSynonyms();
        int synCount = 1;
        for (Synonym aSyn : syns) {
            tsb = new TermSynonymBean();
            tsb.setParentTerm(trm);
            String synVal = this.safeTrim(aSyn.getText());
            if (synVal != null) {
                tsb.setSynonym(synVal);
                if (synVal.length() > 2000) {
                    logger.warn((Object)("synonym value longer than allowed database column length - truncating " + trm.getIdentifier()));
                    tsb.setSynonym(tsb.getSynonym().substring(0, 2000));
                }
                if (aSyn.getSynonymType() != null) {
                    logger.debug((Object)("using user-defined synonym type: " + aSyn.getSynonymType().getName()));
                    Term synTrm = this.ontologyTerms.get(aSyn.getSynonymType().getID());
                    if (synTrm == null) throw new IllegalStateException("Attempting to use user-defined synonym type that has not been initialized in common objects: " + aSyn.getSynonymType().getID());
                    tsb.setSynonymType(synTrm);
                } else {
                    switch (aSyn.getScope()) {
                        case 1: {
                            tsb.setSynonymType(this.EXACT);
                            break;
                        }
                        case 2: {
                            tsb.setSynonymType(this.NARROW);
                            break;
                        }
                        case 3: {
                            tsb.setSynonymType(this.BROAD);
                            break;
                        }
                        case 0: {
                            tsb.setSynonymType(this.RELATED);
                            break;
                        }
                        default: {
                            tsb.setSynonymType(this.SYNONYM);
                        }
                    }
                }
                Collection oboSynXrefs = aSyn.getXrefs();
                if (oboSynXrefs != null) {
                    HashSet<DbXref> xrefs = new HashSet<DbXref>();
                    for (Dbxref xref : oboSynXrefs) {
                        xrefs.add(this.createDbXref(xref, 1));
                    }
                    tsb.setSynonymXrefs(xrefs);
                }
                tsb.setSynonymPk(this.SHORT_NAME + synCount++ * tsb.hashCode() + "!" + trm.getTermPk());
                if (tsb.getSynonymPk().length() > 255) {
                    throw new IllegalStateException("synonym PK longer than allowed database column length: " + tsb.getSynonymPk());
                }
                retval.add(tsb);
                continue;
            }
            logger.debug((Object)("Null Synonym value encountered for " + trm.getIdentifier()));
        }
        Set altIDs = obj.getSecondaryIDs();
        for (String altID : altIDs) {
            TermSynonymBean tsb2 = new TermSynonymBean();
            tsb2.setParentTerm(trm);
            tsb2.setSynonym(this.safeTrim(altID));
            if (altID != null && altID.length() > 2000) {
                logger.warn((Object)("synonym value longer than allowed database column length - truncating " + trm.getIdentifier()));
                tsb2.setSynonym(tsb2.getSynonym().substring(0, 2000));
            }
            tsb2.setSynonymType(this.ALT_ID);
            tsb2.setSynonymPk(this.SHORT_NAME + synCount++ * tsb2.hashCode() + "!" + trm.getTermPk());
            if (tsb2.getSynonymPk().length() > 255) {
                throw new IllegalStateException("synonym PK longer than allowed database column length: " + tsb2.getSynonymPk());
            }
            retval.add(tsb2);
        }
        try {
            String altID;
            if (!trm.getIdentifier().toLowerCase().startsWith("http:")) return retval;
            altID = trm.getIdentifier().substring(trm.getIdentifier().lastIndexOf("/") + 1);
            tsb = new TermSynonymBean();
            tsb.setParentTerm(trm);
            tsb.setSynonym(this.safeTrim(altID));
            if (altID != null && altID.length() > 2000) {
                logger.warn((Object)("synonym value longer than allowed database column length - truncating " + trm.getIdentifier()));
                tsb.setSynonym(tsb.getSynonym().substring(0, 2000));
            }
            tsb.setSynonymType(this.ALT_ID);
            tsb.setSynonymPk(this.SHORT_NAME + synCount++ * tsb.hashCode() + "!" + trm.getTermPk());
            if (tsb.getSynonymPk().length() > 255) {
                throw new IllegalStateException("synonym PK longer than allowed database column length: " + tsb.getSynonymPk());
            }
            retval.add(tsb);
            return retval;
        }
        catch (IndexOutOfBoundsException e) {
            logger.debug((Object)("Could not create alt_id from URL from term: " + trm.getIdentifier()));
        }
        return retval;
    }

    protected void dumpOntology() {
        for (String id : this.getRootTerms()) {
            logger.debug((Object)("Root term: " + id));
            this.dumpTerm(this.ontologyTerms.get(id), "");
        }
    }

    protected void dumpOntologyStats() {
        int ts = 0;
        int tp = 0;
        int tr = 0;
        int ta = 0;
        for (Term tb : this.ontologyTerms.values()) {
            if (tb.getSynonyms() != null) {
                ts += tb.getSynonyms().size();
            }
            if (tb.getPaths() != null) {
                tp += tb.getPaths().size();
            }
            if (tb.getRelationships() != null) {
                tr += tb.getRelationships().size();
            }
            if (tb.getAnnotations() == null) continue;
            ta += tb.getAnnotations().size();
        }
        logger.info((Object)("Number of terms: " + this.ontologyTerms.size()));
        logger.info((Object)("Number of synonyms: " + ts));
        logger.info((Object)("Number of relationships: " + tr));
        logger.info((Object)("Number of paths: " + tp));
        logger.info((Object)("Number of annotations: " + ta));
    }

    protected void dumpTerm(Term term, String indent) {
        if (indent.length() > 15) {
            return;
        }
        if (term != null) {
            logger.debug((Object)(indent + "id: " + term.getIdentifier()));
            logger.debug((Object)(indent + "name: " + term.getName()));
            if (term.getSynonyms() != null) {
                logger.debug((Object)(indent + "nb syn: " + term.getSynonyms().size()));
            }
            if (term.getAnnotations() != null) {
                logger.debug((Object)(indent + "nb annot: " + term.getAnnotations().size()));
            }
            if (term.getRelationships() != null) {
                for (TermRelationship tr : term.getRelationships()) {
                    String relationStr = indent + tr.getSubjectTerm().getName() + " " + tr.getPredicateTerm().getName() + " " + tr.getObjectTerm().getName();
                    logger.debug((Object)relationStr);
                    this.dumpTerm(tr.getSubjectTerm(), indent + " ");
                }
            }
        }
    }

    protected String safeTrim(String inStr) {
        if (inStr != null) {
            String tmp = inStr.trim();
            if (tmp.length() > 0) {
                return tmp;
            }
            return null;
        }
        return null;
    }

    @Override
    public Ontology getOntology() throws IOException {
        if (this.ontBean != null) {
            return this.ontBean;
        }
        throw new IllegalStateException("OntologyAccess bean not properly initialized. Did you call the proper sequence of methods: configure(), parse(), process()?");
    }
}

