/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.ols.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bbop.dataadapter.AdapterConfiguration;
import org.bbop.dataadapter.DataAdapterException;
import org.biopax.ols.Parser;
import org.obo.dataadapter.OBOAdapter;
import org.obo.dataadapter.OBOFileAdapter;
import org.obo.datamodel.IdentifiedObject;
import org.obo.datamodel.Instance;
import org.obo.datamodel.Link;
import org.obo.datamodel.LinkDatabase;
import org.obo.datamodel.LinkedObject;
import org.obo.datamodel.OBOClass;
import org.obo.datamodel.OBOObject;
import org.obo.datamodel.OBOSession;
import org.obo.datamodel.RootAlgorithm;
import org.obo.util.TermUtil;

public class OBO2FormatParser
implements Parser {
    private static Log logger = LogFactory.getLog(OBO2FormatParser.class);
    private OBOSession session = null;

    public OBO2FormatParser(String filePath) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().add(filePath);
        this.session = (OBOSession)adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    public OBO2FormatParser(Collection<String> filePaths) throws DataAdapterException {
        OBOFileAdapter adapter = new OBOFileAdapter();
        OBOFileAdapter.OBOAdapterConfiguration config = new OBOFileAdapter.OBOAdapterConfiguration();
        config.getReadPaths().addAll(filePaths);
        this.session = (OBOSession)adapter.doOperation(OBOAdapter.READ_ONTOLOGY, (AdapterConfiguration)config, null);
    }

    @Override
    public Set<OBOObject> getTerms() {
        LinkDatabase lnkDb = this.session.getLinkDatabase();
        HashSet<OBOObject> terms = new HashSet<OBOObject>();
        for (IdentifiedObject io : lnkDb.getObjects()) {
            if (!(io instanceof OBOClass) && !(io instanceof Instance) || io.getID().toLowerCase().startsWith("obo:")) continue;
            terms.add((OBOObject)io);
        }
        return terms;
    }

    @Override
    public OBOSession getSession() {
        return this.session;
    }

    @Override
    public Set<OBOObject> getRootTerms(boolean useGreedy) {
        HashSet<OBOObject> roots = new HashSet<OBOObject>();
        if (useGreedy) {
            Collection tmpRoots = TermUtil.getRoots((OBOSession)this.session);
            roots.addAll(tmpRoots);
        } else {
            Collection tmpRoots = TermUtil.getRoots((RootAlgorithm)RootAlgorithm.STRICT, (LinkDatabase)this.session.getLinkDatabase());
            for (LinkedObject lnk : tmpRoots) {
                if (!(lnk instanceof OBOClass)) continue;
                roots.add((OBOObject)((OBOClass)lnk));
            }
        }
        return roots;
    }

    private HashMap<String, Integer> computeChildPaths(int distance, Set relationshipType, LinkedObject term, HashMap<String, Integer> paths) {
        Collection children = term.getChildren();
        for (Link trm : children) {
            if (!relationshipType.contains(trm.getType().getID())) continue;
            paths.put(trm.getChild().getID(), distance);
            try {
                this.computeChildPaths(distance + 1, relationshipType, trm.getChild(), paths);
            }
            catch (StackOverflowError e) {
                logger.error((Object)("Stack overflow when computing child paths for: " + term.getID() + " for relationships: " + relationshipType));
                throw new IllegalStateException(e);
            }
        }
        return paths;
    }

    @Override
    public HashMap<String, Integer> computeChildPaths(int distance, Set relationshipType, LinkedObject term) {
        return this.computeChildPaths(distance, relationshipType, term, new HashMap<String, Integer>());
    }
}

