/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.ols.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.bbop.dataadapter.DataAdapterException;
import org.biopax.ols.Ontology;
import org.biopax.ols.Term;
import org.biopax.ols.TermPath;
import org.biopax.ols.TermRelationship;
import org.biopax.ols.impl.BaseOBO2AbstractLoader;
import org.biopax.ols.impl.OBO2FormatParser;

public class OntologyBean
implements Ontology {
    private long ontologyId;
    private String shortOntologyName = null;
    private String fullOntologyName = null;
    private String definition = null;
    private String queryURL = null;
    private String sourceURL = null;
    private Collection<Term> terms = null;
    private Collection<Term> rootTerms = null;
    private Collection<TermRelationship> termRelationships = null;
    private Collection<TermPath> termPaths = null;
    private Date loadDate = null;
    private String version = null;
    private boolean fullyLoaded = false;
    private boolean usesImports = false;

    public long getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(long _ontologyId) {
        this.ontologyId = _ontologyId;
    }

    @Override
    public String getShortOntologyName() {
        return this.shortOntologyName;
    }

    public void setShortOntologyName(String _ontologyName) {
        this.shortOntologyName = _ontologyName;
    }

    @Override
    public String getFullOntologyName() {
        return this.fullOntologyName;
    }

    public void setFullOntologyName(String _ontologyName) {
        this.fullOntologyName = _ontologyName;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String _definition) {
        this.definition = _definition;
    }

    @Override
    public Collection<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(Collection<Term> _terms) {
        this.terms = _terms;
    }

    @Override
    public Collection<Term> getRootTerms() {
        if (this.rootTerms == null) {
            this.rootTerms = new ArrayList<Term>();
            if (this.terms != null) {
                for (Term term : this.terms) {
                    if (!term.isRootTerm()) continue;
                    this.rootTerms.add(term);
                }
            }
        }
        return this.rootTerms;
    }

    public void setRootTerms(Collection<Term> rootTerms) {
        this.rootTerms = rootTerms;
    }

    public Collection<TermRelationship> getTermRelationships() {
        return this.termRelationships;
    }

    public void setTermRelationships(Collection<TermRelationship> _termRelationships) {
        this.termRelationships = _termRelationships;
    }

    public Collection<TermPath> getTermPaths() {
        return this.termPaths;
    }

    public void setTermPaths(Collection<TermPath> _termPaths) {
        this.termPaths = _termPaths;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String _version) {
        this.version = _version;
    }

    @Override
    public java.util.Date getLoadDate() {
        return this.loadDate;
    }

    public void setLoadDate(Date _loadDate) {
        this.loadDate = _loadDate;
    }

    public void setLoadData(java.util.Date _loadDate) {
        this.loadDate = new Date(_loadDate.getTime());
    }

    public boolean getFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    @Override
    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    @Override
    public String getQueryURL() {
        return this.queryURL;
    }

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    @Override
    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    @Override
    public boolean isUsesImports() {
        return this.usesImports;
    }

    public void setUsesImports(boolean usesImports) {
        this.usesImports = usesImports;
    }

    public String toString() {
        return "OntologyBean{" + "ontologyId=" + this.ontologyId + ", shortOntologyName='" + this.shortOntologyName + '\'' + ", fullOntologyName='" + this.fullOntologyName + '\'' + ", definition='" + this.definition + '\'' + ", queryURL='" + this.queryURL + '\'' + ", sourceURL='" + this.sourceURL + '\'' + ", terms=" + this.terms + ", rootTerms=" + this.rootTerms + ", termRelationships=" + this.termRelationships + ", termPaths=" + this.termPaths + ", loadDate=" + this.loadDate + ", version='" + this.version + '\'' + ", fullyLoaded=" + this.fullyLoaded + ", usesImports=" + this.usesImports + '}';
    }

    public static Ontology loadFromOBOFile(String oboFilePath, String shortName, String fullName, String definition) throws IOException {
        File oboFile = new File(oboFilePath);
        if (!oboFile.exists()) {
            throw new IOException("The file path to be parsed does not exist");
        }
        return OntologyBean.loadFromOBOFile(oboFile, shortName, fullName, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ontology loadFromOBOFile(URL oboFileURL, String shortName, String fullName, String definition) throws IOException {
        if (oboFileURL == null) {
            throw new IOException("The URL to be parsed must not be null.");
        }
        System.out.println("OntologyBean.loadFromOBOFile will read from: " + oboFileURL.toString());
        URLConnection conn = null;
        BufferedReader in = null;
        PrintWriter out = null;
        File tempFile = null;
        try {
            String line;
            boolean useNumericalProgressDisplay = false;
            conn = oboFileURL.openConnection();
            int contentLength = conn.getContentLength();
            if (contentLength > 0) {
                useNumericalProgressDisplay = true;
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()), 4096);
            File tempDirectory = new File(System.getProperty("java.io.tmpdir", "tmp"));
            if (!tempDirectory.exists() && !tempDirectory.mkdirs()) {
                throw new IOException("Cannot create temp directory: " + tempDirectory.getAbsolutePath());
            }
            tempFile = File.createTempFile("ontologyBean.", ".obo", tempDirectory);
            tempFile.deleteOnExit();
            out = new PrintWriter(new FileWriter(tempFile));
            int currentSize = 0;
            int currentPct = 0;
            int lineCount = 0;
            int reportInc = 10;
            int lastPct = -1;
            while ((line = in.readLine()) != null) {
                out.println(line);
                if (useNumericalProgressDisplay) {
                    currentPct = (currentSize += line.length()) * 100 / contentLength;
                    if (currentPct % reportInc != 0 || currentPct == lastPct) continue;
                    System.out.print(currentPct + "% ");
                    System.out.flush();
                    lastPct = currentPct;
                    continue;
                }
                if (++lineCount % 20 != 0) continue;
                System.out.print(".");
                System.out.flush();
                if (lineCount % 500 != 0) continue;
                System.out.println("   " + lineCount);
            }
            System.out.println();
            System.out.println("OntologyBean.loadFromOBOFile is processing file.");
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return OntologyBean.loadFromOBOFile(tempFile, shortName, fullName, definition);
    }

    public static Ontology loadFromOBOFile(final File oboFile, final String shortName, final String fullName, final String definition) throws IOException {
        if (shortName == null || shortName != null && "".equals(shortName.trim())) {
            throw new IllegalArgumentException("The ShortName of an ontology cannot be null");
        }
        if (!oboFile.exists()) {
            throw new IOException("The file path to be parsed does not exist");
        }
        BaseOBO2AbstractLoader loader = new BaseOBO2AbstractLoader(){

            protected void configure() throws DataAdapterException {
                this.parser = new OBO2FormatParser(oboFile.getAbsolutePath());
                this.setUseGreedy(false);
                this.ONTOLOGY_DEFINITION = definition;
                this.FULL_NAME = fullName;
                this.SHORT_NAME = shortName;
            }

            @Override
            public Ontology getOntology() throws IOException {
                try {
                    this.configure();
                    this.process();
                    return super.getOntology();
                }
                catch (IllegalStateException ise) {
                    throw new IOException("There were errors while loading the ontology: " + ise.getMessage());
                }
                catch (DataAdapterException ioe) {
                    throw new IOException("There were errors while loading the ontology: " + ioe.getMessage());
                }
            }
        };
        return loader.getOntology();
    }
}

