/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.psidev.ontology_manager.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.psidev.ontology_manager.OntologyAccess;
import org.biopax.psidev.ontology_manager.OntologyManager;
import org.biopax.psidev.ontology_manager.OntologyTermI;
import org.biopax.psidev.ontology_manager.impl.OboLoader;
import org.biopax.psidev.ontology_manager.impl.OntologyLoaderException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class OntologyManagerImpl
implements OntologyManager {
    public static final Log log = LogFactory.getLog(OntologyManagerImpl.class);
    private static final ResourceLoader LOADER = new DefaultResourceLoader();
    private Map<String, OntologyAccess> ontologyMap = new HashMap<String, OntologyAccess>();

    public OntologyManagerImpl() {
    }

    public OntologyManagerImpl(Properties cfg) throws OntologyLoaderException {
        this();
        this.loadOntologies(cfg);
        log.debug((Object)"Successfully created and configured new OntologyManagerImpl.");
    }

    @Override
    public void putOntology(String ontologyID, OntologyAccess ontologyAccess) {
        if (this.ontologyMap.containsKey(ontologyID)) {
            log.warn((Object)("OntologyAccess with the ID '" + ontologyID + "' already exists. Overwriting!"));
        }
        this.ontologyMap.put(ontologyID, ontologyAccess);
    }

    @Override
    public Set<String> getOntologyIDs() {
        return this.ontologyMap.keySet();
    }

    @Override
    public OntologyAccess getOntology(String ontologyID) {
        return this.ontologyMap.get(ontologyID);
    }

    @Override
    public boolean containsOntology(String ontologyID) {
        return this.ontologyMap.containsKey(ontologyID);
    }

    @Override
    public void loadOntologies(Properties config) throws OntologyLoaderException {
        if (config != null && !config.isEmpty()) {
            for (Object ontId : config.keySet()) {
                String key = (String)ontId;
                try {
                    URI uri = LOADER.getResource(config.getProperty(key)).getURI();
                    log.info((Object)("Loading ontology: ID= " + ontId + ", uri=" + uri));
                    OntologyAccess oa = this.fetchOntology(key, "OBO", uri);
                    this.putOntology(key, oa);
                }
                catch (Throwable e) {
                    throw new OntologyLoaderException("Failed loading/parsing ontology " + key + " from " + config.getProperty(key), e);
                }
            }
        } else {
            throw new OntologyLoaderException("OntologyAccess configuration map is missing or empty (map)!");
        }
    }

    protected OntologyAccess fetchOntology(String ontologyID, String format, URI uri) throws OntologyLoaderException {
        OntologyAccess oa = null;
        if ("OBO".equals(format)) {
            URL url;
            if (uri == null) {
                throw new IllegalArgumentException("The given CvSource doesn't have a URL");
            }
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The given CvSource doesn't have a valid URL: " + uri);
            }
            OboLoader loader = new OboLoader();
            try {
                log.debug((Object)("Parsing ontology at URL: " + url));
                oa = loader.parseOboFile(url, ontologyID);
                oa.setName(ontologyID);
            }
            catch (Exception e) {
                throw new OntologyLoaderException("OboFile parser failed with Exception: ", e);
            }
        }
        throw new OntologyLoaderException("Unsupported ontology format: " + format);
        log.info((Object)("Successfully created OntologyAccessImpl from values: ontology=" + ontologyID + " format=" + format + " location=" + uri));
        return oa;
    }

    @Override
    public Set<OntologyTermI> searchTermByName(String name) {
        return this.searchTermByName(name, null);
    }

    @Override
    public Set<OntologyTermI> searchTermByName(String name, Set<String> ontologies) {
        HashSet<OntologyTermI> found = new HashSet<OntologyTermI>();
        assert (name != null) : "searchTermByName: null arg.";
        HashSet<String> ontologyIDs = new HashSet<String>(this.getOntologyIDs());
        if (ontologies != null && !ontologies.isEmpty()) {
            ontologyIDs.retainAll(ontologies);
        }
        for (String ontologyId : ontologyIDs) {
            OntologyAccess oa = this.getOntology(ontologyId);
            for (OntologyTermI term : oa.getOntologyTerms()) {
                String prefName = term.getPreferredName();
                if (prefName == null) {
                    log.error((Object)("searchTermByName: NULL preffered name for term " + term.getTermAccession() + " in " + ontologyId + "; report to authors."));
                    continue;
                }
                if (name.equalsIgnoreCase(prefName)) {
                    found.add(term);
                    continue;
                }
                for (String syn : term.getNameSynonyms()) {
                    if (!syn.equalsIgnoreCase(name)) continue;
                    found.add(term);
                }
            }
        }
        return found;
    }

    @Override
    public OntologyTermI findTermByAccession(String acc) {
        String ontologyId;
        OntologyTermI term = null;
        Iterator<String> iterator = this.getOntologyIDs().iterator();
        while (iterator.hasNext() && (term = this.getOntology(ontologyId = iterator.next()).getTermForAccession(acc)) == null) {
        }
        return term;
    }

    protected static Collection<String> getTermNames(Collection<OntologyTermI> terms) {
        if (terms == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(terms.size());
        for (OntologyTermI term : terms) {
            names.add(term.getPreferredName());
            names.addAll(term.getNameSynonyms());
        }
        return names;
    }
}

