/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.commandline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bbop.commandline.ArgumentSignature;
import org.bbop.commandline.CommandLineParser;
import org.bbop.commandline.FailException;
import org.bbop.commandline.UnfullfilledException;

public class EnumArgumentSignature
implements ArgumentSignature {
    protected static final Logger logger = Logger.getLogger(EnumArgumentSignature.class);
    protected List signatures = new ArrayList();
    protected ArgumentSignature current;
    protected int id = CommandLineParser.getID();
    protected int index = 0;
    protected boolean triedDefault = false;
    int defaultIndex = -1;
    protected String shortDocumentation;

    public int getID() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof ArgumentSignature) {
            return ((ArgumentSignature)o).getID() == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public EnumArgumentSignature() {
        this(null);
    }

    public EnumArgumentSignature(String shortDocumenation) {
        this.shortDocumentation = shortDocumenation;
    }

    public String getShortDocumentation() {
        if (this.shortDocumentation == null) {
            StringBuffer out = new StringBuffer();
            Iterator it = this.signatures.iterator();
            boolean first = true;
            while (it.hasNext()) {
                ArgumentSignature as = (ArgumentSignature)it.next();
                if (!first) {
                    out.append(" | ");
                }
                out.append(as.getShortDocumentation());
                first = false;
            }
            return "(" + out.toString() + ")";
        }
        return this.shortDocumentation;
    }

    public String toString() {
        return super.toString();
    }

    public void setOnlyAcceptAsLastResort(boolean lastResort) {
    }

    public ArgumentSignature copy() {
        EnumArgumentSignature out = new EnumArgumentSignature();
        for (ArgumentSignature sig : this.signatures) {
            out.signatures.add(sig.copy());
        }
        if (this.current != null) {
            out.current = this.current.copy();
        }
        out.id = this.id;
        out.defaultIndex = this.defaultIndex;
        out.index = this.index;
        out.triedDefault = this.triedDefault;
        return out;
    }

    public void init(CommandLineParser p, boolean defaultMode) {
        this.current = null;
        this.index = 0;
        this.triedDefault = false;
        for (ArgumentSignature sig : this.signatures) {
            sig.init(p, false);
        }
    }

    public boolean onlyAcceptAsLastResort() {
        return false;
    }

    public void addSignature(ArgumentSignature as) {
        this.addSignature(as, false);
    }

    public void addSignature(ArgumentSignature as, boolean isDefault) {
        as.setOnlyAcceptAsLastResort(false);
        this.signatures.add(as);
        if (isDefault) {
            this.defaultIndex = this.signatures.size() - 1;
        }
    }

    public void accept(CommandLineParser p) throws FailException {
        ArgumentSignature sig;
        if (this.current != null) {
            throw new FailException("UNEXPECTED CONDITION: Illegal attempt to reassign enum value");
        }
        while (this.index < this.signatures.size()) {
            sig = (ArgumentSignature)this.signatures.get(this.index);
            try {
                p.doAccept(sig);
                this.current = sig.copy();
                return;
            }
            catch (FailException failException) {
                ++this.index;
            }
        }
        if (!this.triedDefault && this.defaultIndex != -1) {
            sig = (ArgumentSignature)this.signatures.get(this.defaultIndex);
            sig.init(p, true);
            p.doAccept(sig, true);
            this.current = sig.copy();
            return;
        }
        String optionStr = this.signatures.toString();
        throw new FailException("Expected " + optionStr + ", found " + p.peekNextString());
    }

    public List getValues() throws UnfullfilledException {
        if (this.current == null) {
            throw new UnfullfilledException();
        }
        return this.current.getValues();
    }
}

