/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.dataadapter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.bbop.dataadapter.AdapterConfiguration;

public class JDBCAdapterConfiguration
implements AdapterConfiguration {
    protected static final Logger logger = Logger.getLogger(JDBCAdapterConfiguration.class);
    protected int maxReadHistorySize;
    protected int maxWriteHistorySize;
    protected String readPath;
    protected String dbUsername;
    protected String dbPassword = "";
    protected String writePath;
    protected Connection conn;

    public JDBCAdapterConfiguration(String jdbcPath) {
        this();
        this.readPath = jdbcPath;
    }

    public JDBCAdapterConfiguration() {
    }

    public String getReadPath() {
        return this.readPath;
    }

    public void setReadPath(String readPath) {
        this.readPath = readPath;
    }

    public void setWritePath(String path) {
        this.writePath = path;
    }

    public String getWritePath() {
        return this.writePath;
    }

    public String toString() {
        return "readPaths = " + this.readPath;
    }

    public Connection getConnection() throws SQLException, ClassNotFoundException {
        String password;
        Class.forName("org.postgresql.Driver");
        String username = this.getDbUsername();
        if (username == null) {
            String systemUser = System.getenv("USER");
            if (systemUser == null) {
                logger.info((Object)"WARN: No username specified for database connection. Attempting to connect without a user.");
                username = "";
            } else {
                logger.info((Object)("WARN: No username specified for database connection. Using environmental username " + systemUser));
                username = systemUser;
            }
        }
        if ((password = this.getDbPassword()) == null) {
            logger.info((Object)"WARN: No password specified for database connection.");
            password = "";
        }
        return DriverManager.getConnection(this.readPath, username, password);
    }

    public void getConnection(String driverstring, String host, String db, String port, String user, String password) {
        if (host == null) {
            host = "genome-venus.ad.uab.edu";
        }
        if (port == null) {
            port = "3508";
        }
        if (db == null) {
            db = "ozborn_vgd_common_61";
        }
        driverstring = driverstring == null ? "jdbc:jtds:sqlserver://" + host + ":" + port + "/" + db : driverstring + host + ":" + port + "/" + db;
        Properties prop = new Properties();
        prop.setProperty("user", user);
        prop.setProperty("password", password);
        prop.setProperty("ssl", "request");
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            this.conn = DriverManager.getConnection(driverstring, prop);
        }
        catch (SQLException se) {
            System.out.println("Error code:" + se.getErrorCode());
            System.out.println("Local Message :" + se.getLocalizedMessage());
            System.out.println("Cause :" + se.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }
}

