/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.ASTArrayAccess;
import org.bbop.expression.parser.ASTIdentifier;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;

public class ASTReference
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTReference.class);
    protected SimpleNode root;

    public ASTReference(int id) {
        super(id);
    }

    public ASTReference(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws Exception {
        return this.execute(null, jc);
    }

    public void jjtClose() {
        this.root = (SimpleNode)this.jjtGetChild(0);
    }

    public Object execute(Object obj, JexlContext jc) throws Exception {
        Object o = this.root.value(jc);
        for (int i = 1; i < this.jjtGetNumChildren(); ++i) {
            o = ((SimpleNode)this.jjtGetChild(i)).execute(o, jc);
            if (o != null) continue;
            String varName = this.getIdentifierToDepth(i);
            o = jc.getVariableValue(varName);
        }
        return o;
    }

    private String getIdentifierToDepth(int i) {
        StringBuffer varName = new StringBuffer();
        for (int j = 0; j <= i; ++j) {
            SimpleNode node = (SimpleNode)this.jjtGetChild(j);
            if (!(node instanceof ASTIdentifier)) continue;
            varName.append(((ASTIdentifier)node).getIdentifierString());
            if (j == i) continue;
            varName.append('.');
        }
        return varName.toString();
    }

    public String getRootString() throws Exception {
        if (this.root instanceof ASTIdentifier) {
            return ((ASTIdentifier)this.root).getIdentifierString();
        }
        if (this.root instanceof ASTArrayAccess) {
            return ((ASTArrayAccess)this.root).getIdentifierString();
        }
        this.throwExpressionException("programmer error : ASTReference : root not known" + this.root);
        return null;
    }
}

