/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.parser;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.expression.JexlContext;
import org.bbop.expression.parser.Parser;
import org.bbop.expression.parser.ParserVisitor;
import org.bbop.expression.parser.SimpleNode;
import org.bbop.expression.util.Introspector;
import org.bbop.expression.util.introspection.Info;
import org.bbop.expression.util.introspection.VelMethod;

public class ASTSizeFunction
extends SimpleNode {
    protected static final Logger logger = Logger.getLogger(ASTSizeFunction.class);

    public ASTSizeFunction(int id) {
        super(id);
    }

    public ASTSizeFunction(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws Exception {
        SimpleNode arg = (SimpleNode)this.jjtGetChild(0);
        Object val = arg.value(jc);
        if (val == null) {
            this.throwExpressionException("size() : null arg");
        }
        return new Integer(ASTSizeFunction.sizeOf(val, this));
    }

    public static int sizeOf(Object val, SimpleNode node) throws Exception {
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val);
        }
        if (val instanceof Map) {
            return ((Map)val).size();
        }
        if (val instanceof String) {
            return ((String)val).length();
        }
        Object[] params = new Object[]{};
        Info velInfo = new Info("", 1, 1);
        VelMethod vm = Introspector.getUberspect().getMethod(val, "size", params, velInfo);
        if (vm != null && vm.getReturnType() == Integer.TYPE) {
            Integer result = (Integer)vm.invoke(val, params);
            return result;
        }
        node.throwExpressionException("size() : unknown type : " + val.getClass());
        return -1;
    }
}

