/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.util;

import org.apache.log4j.Logger;
import org.bbop.expression.ExpressionException;

public class Coercion {
    protected static final Logger logger = Logger.getLogger(Coercion.class);

    public static Boolean coerceBoolean(Object val) {
        if (val == null) {
            return Boolean.FALSE;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return null;
    }

    public static Integer coerceInteger(Object val) throws ExpressionException {
        if (val == null) {
            return new Integer(0);
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return new Integer(0);
            }
            return Integer.valueOf((String)val);
        }
        if (val instanceof Character) {
            return new Integer(((Character)val).charValue());
        }
        if (val instanceof Boolean) {
            throw new ExpressionException("Boolean->Integer coercion exception");
        }
        if (val instanceof Number) {
            return new Integer(((Number)val).intValue());
        }
        throw new ExpressionException("Integer coercion exception");
    }

    public static Long coerceLong(Object val) throws ExpressionException {
        if (val == null) {
            return new Long(0L);
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return new Long(0L);
            }
            return Long.valueOf((String)val);
        }
        if (val instanceof Character) {
            return new Long(((Character)val).charValue());
        }
        if (val instanceof Boolean) {
            throw new ExpressionException("Boolean->Long coercion exception");
        }
        if (val instanceof Number) {
            return new Long(((Number)val).longValue());
        }
        throw new ExpressionException("Long coercion exception");
    }

    public static Double coerceDouble(Object val) throws ExpressionException {
        if (val == null) {
            return new Double(0.0);
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return new Double(0.0);
            }
            return new Double((String)val);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new Double(Double.parseDouble(String.valueOf((int)i)));
        }
        if (val instanceof Boolean) {
            throw new ExpressionException("Boolean->Double coercion exception");
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return new Double(Double.parseDouble(String.valueOf(val)));
        }
        throw new ExpressionException("Double coercion exception");
    }

    public static boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    public static boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Character;
    }
}

