/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.util.introspection;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.bbop.expression.util.introspection.IntrospectorBase;
import org.bbop.expression.util.introspection.MethodMap;

public class Introspector
extends IntrospectorBase {
    protected static final Logger logger = Logger.getLogger(Introspector.class);
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";

    public Method getMethod(Class c, String name, Object[] params) throws Exception {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name).append("( ");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(params[i].getClass().getName());
            }
            msg.append(") for class ").append(c.getName());
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
    }
}

