/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.expression.util.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.bbop.expression.util.AbstractExecutor;
import org.bbop.expression.util.ArrayIterator;
import org.bbop.expression.util.BooleanPropertyExecutor;
import org.bbop.expression.util.EnumerationIterator;
import org.bbop.expression.util.GetExecutor;
import org.bbop.expression.util.PropertyExecutor;
import org.bbop.expression.util.introspection.Info;
import org.bbop.expression.util.introspection.Introspector;
import org.bbop.expression.util.introspection.Uberspect;
import org.bbop.expression.util.introspection.VelMethod;
import org.bbop.expression.util.introspection.VelPropertyGet;
import org.bbop.expression.util.introspection.VelPropertySet;

public class UberspectImpl
implements Uberspect {
    protected static final Logger logger = Logger.getLogger(UberspectImpl.class);
    private static final int PROPERTY_START_INDEX = 3;
    private static Introspector introspector;

    public void init() {
        introspector = new Introspector();
    }

    public UberspectImpl() {
        this.init();
    }

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        return null;
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        if (obj == null) {
            return null;
        }
        Method m = introspector.getMethod(obj.getClass(), methodName, args);
        if (m == null && obj instanceof Class) {
            m = introspector.getMethod((Class)obj, methodName, args);
        }
        return m == null ? null : new VelMethodImpl(m);
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        Class<?> claz = obj.getClass();
        AbstractExecutor executor = new PropertyExecutor(introspector, claz, identifier);
        if (!executor.isAlive()) {
            executor = new BooleanPropertyExecutor(introspector, claz, identifier);
        }
        if (!executor.isAlive()) {
            executor = new GetExecutor(introspector, claz, identifier);
        }
        return executor == null ? null : new VelGetterImpl(executor);
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        VelMethod vm;
        block8: {
            Class<?> claz = obj.getClass();
            vm = null;
            try {
                Object[] params = new Object[]{arg};
                try {
                    vm = this.getMethod(obj, "set" + identifier, params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException nsme2) {
                    StringBuffer sb = new StringBuffer("set");
                    sb.append(identifier);
                    if (Character.isLowerCase(sb.charAt(3))) {
                        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
                    } else {
                        sb.setCharAt(3, Character.toLowerCase(sb.charAt(3)));
                    }
                    vm = this.getMethod(obj, sb.toString(), params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
            }
            catch (NoSuchMethodException nsme) {
                Object[] params;
                if (!Map.class.isAssignableFrom(claz) || (vm = this.getMethod(obj, "put", params = new Object[]{new Object(), new Object()}, i)) == null) break block8;
                return new VelSetterImpl(vm, identifier);
            }
        }
        return vm == null ? null : new VelSetterImpl(vm);
    }

    public class VelSetterImpl
    implements VelPropertySet {
        protected VelMethod vm = null;
        protected String putKey = null;

        public VelSetterImpl(VelMethod velmethod) {
            this.vm = velmethod;
        }

        public VelSetterImpl(VelMethod velmethod, String key) {
            this.vm = velmethod;
            this.putKey = key;
        }

        public Object invoke(Object o, Object value) throws Exception {
            ArrayList<Object> al = new ArrayList<Object>();
            if (this.putKey == null) {
                al.add(value);
            } else {
                al.add(this.putKey);
                al.add(value);
            }
            return this.vm.invoke(o, al.toArray());
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.vm.getMethodName();
        }
    }

    public class VelGetterImpl
    implements VelPropertyGet {
        protected AbstractExecutor ae = null;

        public VelGetterImpl(AbstractExecutor exec) {
            this.ae = exec;
        }

        public Object invoke(Object o) throws Exception {
            return this.ae.execute(o);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.ae.getMethod().getName();
        }
    }

    public class VelMethodImpl
    implements VelMethod {
        protected Method method = null;

        public VelMethodImpl(Method m) {
            this.method = m;
        }

        public Object invoke(Object o, Object[] params) throws Exception {
            try {
                return this.method.invoke(o, params);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw e;
            }
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }
    }
}

