/*
 * Decompiled with CFR 0.152.
 */
package org.bbop.framework;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.SecondaryWindow;
import org.apache.log4j.Logger;
import org.bbop.framework.GUIManager;

public class HelpManager {
    protected static final Logger logger = Logger.getLogger(HelpManager.class);
    protected static HelpManager manager;
    protected HelpBroker helpBroker;
    protected File helpSetFile;

    protected HelpManager() {
    }

    public boolean isEnabled() {
        return this.helpBroker != null;
    }

    public static HelpManager getManager() {
        if (manager == null) {
            manager = new HelpManager();
        }
        return manager;
    }

    public void setHelpSetFile(File helpSetFile) {
        this.helpSetFile = helpSetFile;
        this.helpBroker = HelpManager.createHelpBroker(helpSetFile);
    }

    public void displayHelp() {
        new CSH.DisplayHelpFromSource(this.helpBroker).actionPerformed(new ActionEvent(GUIManager.getManager().getFrame(), 0, "help"));
    }

    public void displayHelp(String topicID) {
        this.displayHelp(GUIManager.getManager().getFrame(), topicID);
    }

    public void displayHelp(Component invoker, String topicID) {
        try {
            SecondaryWindow popup = (SecondaryWindow)SecondaryWindow.getPresentation((HelpSet)this.helpBroker.getHelpSet(), null);
            if (topicID != null) {
                popup.setCurrentID(topicID);
            }
            popup.setDisplayed(true);
        }
        catch (Exception ee) {
            logger.info((Object)("trouble with visiting id; " + ee));
        }
    }

    public HelpBroker getBroker() {
        return this.helpBroker;
    }

    protected static HelpBroker createHelpBroker(File docsDir) {
        HelpSet hs;
        try {
            hs = new HelpSet(null, docsDir.toURL());
        }
        catch (Exception ee) {
            return null;
        }
        return hs.createHelpBroker();
    }
}

